/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import java.util.List;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerElementContainerTest
extends ModelReconcilerTest {
    public void testElementContainer_Children_Add() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setLabel("newPart");
        window.getChildren().add(part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        part = (MPart)window.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((String)"newPart", (String)part.getLabel());
    }

    public void testElementContainer_Children_Add2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setLabel("newPart");
        window.getChildren().add(part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part, window.getChildren().get(0));
        part = (MPart)window.getChildren().get(0);
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part, window.getChildren().get(0));
        part = (MPart)window.getChildren().get(1);
        ModelReconcilerElementContainerTest.assertEquals((String)"newPart", (String)part.getLabel());
    }

    public void testElementContainer_Children_Add3() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setLabel("newPart");
        stack.getChildren().add(part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack = (MPartStack)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)stack.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)stack.getChildren().size());
        part = (MPart)stack.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((String)"newPart", (String)part.getLabel());
    }

    public void testElementContainer_Children_Add4() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPart editor = BasicFactoryImpl.eINSTANCE.createPart();
        editor.setLabel("newEditor");
        window.getChildren().add(editor);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        editor = (MPart)window.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((String)"newEditor", (String)editor.getLabel());
    }

    public void testElementContainer_Children_Add5() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPerspectiveStack stack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        MPerspective perspective = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspective.setLabel("newEditor");
        stack.getChildren().add(perspective);
        window.getChildren().add(stack);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        stack = (MPerspectiveStack)window.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)stack.getChildren().size());
        perspective = (MPerspective)stack.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((String)"newEditor", (String)perspective.getLabel());
    }

    public void testElementContainer_Children_Add6() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)(window.getChildren().get(0) instanceof MPerspectiveStack));
    }

    public void testElementContainer_Children_Remove() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part, window.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
    }

    public void testElementContainer_Children_Remove2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part1);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part1 = (MPart)window.getChildren().get(0);
        part2 = (MPart)window.getChildren().get(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, window.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, window.getChildren().get(1));
        part2 = (MPart)window.getChildren().get(1);
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, window.getChildren().get(0));
    }

    public void testElementContainer_Children_Remove3() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        stack.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack = (MPartStack)window.getChildren().get(0);
        part = (MPart)stack.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)stack.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part, stack.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)stack.getChildren().size());
    }

    public void testElementContainer_Children_Remove4() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(part1);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        stack.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack = (MPartStack)window.getChildren().get(0);
        part1 = (MPart)stack.getChildren().get(0);
        part2 = (MPart)stack.getChildren().get(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)stack.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, stack.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, stack.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)stack.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, stack.getChildren().get(0));
    }

    public void testElementContainer_Children_MovedFromOneStackToAnother() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack1 = BasicFactoryImpl.eINSTANCE.createPartStack();
        MPartStack stack2 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack1);
        window.getChildren().add(stack2);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        stack1.getChildren().add(part1);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        stack2.getChildren().add(part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        stack1.getChildren().remove(part1);
        stack2.getChildren().add(part1);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack1 = (MPartStack)window.getChildren().get(0);
        stack2 = (MPartStack)window.getChildren().get(1);
        part1 = (MPart)stack1.getChildren().get(0);
        part2 = (MPart)stack2.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)stack1.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, stack1.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)stack2.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, stack2.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)stack1.getChildren().size());
        List stack2Children = stack2.getChildren();
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)stack2Children.size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)stack2Children.contains(part1));
        ModelReconcilerElementContainerTest.assertTrue((boolean)stack2Children.contains(part2));
    }

    public void testElementContainer_Children_Repositioned() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(part1);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        stack.getChildren().remove(part1);
        stack.getChildren().add(part1);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack = (MPartStack)window.getChildren().get(0);
        part1 = (MPart)stack.getChildren().get(0);
        part2 = (MPart)stack.getChildren().get(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)stack.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, stack.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, stack.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)stack.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, stack.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, stack.getChildren().get(1));
    }

    public void testElementContainer_Children_Add_Multiple() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartSashContainer partSashContainer = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(partSashContainer);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        partSashContainer.getChildren().add(part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)(window.getChildren().get(0) instanceof MPartSashContainer));
        partSashContainer = (MPartSashContainer)window.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)partSashContainer.getChildren().size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)(partSashContainer.getChildren().get(0) instanceof MPart));
    }

    public void testElementContainer_Children_Add_PartSashContainer() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartSashContainer partSashContainer1 = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(partSashContainer1);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        partSashContainer1.getChildren().add(part1);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartSashContainer partSashContainer2 = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(partSashContainer2);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        partSashContainer2.getChildren().add(part2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        partSashContainer1 = (MPartSashContainer)window.getChildren().get(0);
        part1 = (MPart)partSashContainer1.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)partSashContainer1, window.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)partSashContainer1.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, partSashContainer1.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)partSashContainer1, window.getChildren().get(0));
        partSashContainer2 = (MPartSashContainer)window.getChildren().get(1);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)partSashContainer1.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, partSashContainer1.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)partSashContainer2.getChildren().size());
        ModelReconcilerElementContainerTest.assertNotNull(partSashContainer2.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertTrue((boolean)(partSashContainer2.getChildren().get(0) instanceof MPart));
    }

    public void testElementContainer_Children_Add_TrimBar() {
        MApplication application = this.createApplication();
        MTrimmedWindow window = this.createTrimmedWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        window.getTrimBars().add(trimBar);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MTrimmedWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getTrimBars().size());
        ModelReconcilerElementContainerTest.assertNotNull(window.getTrimBars().get(0));
    }

    public void testElementContainer_Children_Remove_TrimBar() {
        MApplication application = this.createApplication();
        MTrimmedWindow window = this.createTrimmedWindow(application);
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        window.getTrimBars().add(trimBar);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.getTrimBars().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MTrimmedWindow)application.getChildren().get(0);
        trimBar = (MTrimBar)window.getTrimBars().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getTrimBars().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)trimBar, window.getTrimBars().get(0));
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getTrimBars().size());
    }

    public void testElementContainer_Children_Add_ToolBar() {
        MApplication application = this.createApplication();
        MTrimmedWindow window = this.createTrimmedWindow(application);
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        window.getTrimBars().add(trimBar);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        trimBar.getChildren().add(toolBar);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MTrimmedWindow)application.getChildren().get(0);
        trimBar = (MTrimBar)window.getTrimBars().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getTrimBars().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)trimBar, window.getTrimBars().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)trimBar.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getTrimBars().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)trimBar, window.getTrimBars().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)trimBar.getChildren().size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)(trimBar.getChildren().get(0) instanceof MToolBar));
    }

    public void testElementContainer_Children_Remove_ToolBar() {
        MApplication application = this.createApplication();
        MTrimmedWindow window = this.createTrimmedWindow(application);
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        window.getTrimBars().add(trimBar);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        trimBar.getChildren().add(toolBar);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        trimBar.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MTrimmedWindow)application.getChildren().get(0);
        trimBar = (MTrimBar)window.getTrimBars().get(0);
        toolBar = (MToolBar)trimBar.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getTrimBars().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)trimBar, window.getTrimBars().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)trimBar.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)toolBar, trimBar.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)toolBar.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getTrimBars().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)trimBar, window.getTrimBars().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)trimBar.getChildren().size());
    }

    public void testElementContainer_Children_SwitchParent_ToolBar() {
        MApplication application = this.createApplication();
        MTrimmedWindow window = this.createTrimmedWindow(application);
        MTrimBar trimBar1 = BasicFactoryImpl.eINSTANCE.createTrimBar();
        window.getTrimBars().add(trimBar1);
        MTrimBar trimBar2 = BasicFactoryImpl.eINSTANCE.createTrimBar();
        window.getTrimBars().add(trimBar2);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        trimBar1.getChildren().add(toolBar);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        trimBar2.getChildren().add((MTrimElement)trimBar1.getChildren().remove(0));
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MTrimmedWindow)application.getChildren().get(0);
        trimBar1 = (MTrimBar)window.getTrimBars().get(0);
        trimBar2 = (MTrimBar)window.getTrimBars().get(1);
        toolBar = (MToolBar)trimBar1.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)window.getTrimBars().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)trimBar1, window.getTrimBars().get(0));
        ModelReconcilerElementContainerTest.assertEquals((Object)trimBar2, window.getTrimBars().get(1));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)trimBar1.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)toolBar, trimBar1.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)trimBar2.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)toolBar.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)window.getTrimBars().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)trimBar1, window.getTrimBars().get(0));
        ModelReconcilerElementContainerTest.assertEquals((Object)trimBar2, window.getTrimBars().get(1));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)trimBar1.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)trimBar2.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)toolBar, trimBar2.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)toolBar.getChildren().size());
    }

    public void testElementContainer_ActiveChild() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(part1);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        stack.setSelectedElement((MUIElement)part1);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack = (MPartStack)window.getChildren().get(0);
        part1 = (MPart)stack.getChildren().get(0);
        part2 = (MPart)stack.getChildren().get(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertNull((Object)stack.getSelectedElement());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, (Object)stack.getSelectedElement());
    }

    public void testElementContainer_ActiveChild2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(part1);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(part2);
        stack.setSelectedElement((MUIElement)part1);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        stack.setSelectedElement((MUIElement)part2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack = (MPartStack)window.getChildren().get(0);
        part1 = (MPart)stack.getChildren().get(0);
        part2 = (MPart)stack.getChildren().get(1);
        stack.setSelectedElement((MUIElement)part1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, (Object)stack.getSelectedElement());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, (Object)stack.getSelectedElement());
    }

    private void testElementContainer_ActiveChild3(boolean setActiveChildFirst) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartSashContainer partSashContainer = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(partSashContainer);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        if (setActiveChildFirst) {
            partSashContainer.setSelectedElement((MUIElement)part);
            partSashContainer.getChildren().add(part);
        } else {
            partSashContainer.getChildren().add(part);
            partSashContainer.setSelectedElement((MUIElement)part);
        }
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)(window.getChildren().get(0) instanceof MPartSashContainer));
        partSashContainer = (MPartSashContainer)window.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)partSashContainer.getChildren().size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)(partSashContainer.getChildren().get(0) instanceof MPart));
        part = (MPart)partSashContainer.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((Object)part, (Object)partSashContainer.getSelectedElement());
    }

    public void testElementContainer_ActiveChild3_True() {
        this.testElementContainer_ActiveChild3(true);
    }

    public void testElementContainer_ActiveChild3_False() {
        this.testElementContainer_ActiveChild3(false);
    }
}

