/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.services.EContextService;

public class ContextTest
extends TestCase {
    private static final String WINDOW_ID = "org.eclipse.ui.contexts.window";
    private static final String DIALOG_ID = "org.eclipse.ui.contexts.dialog";
    private static final String DIALOG_AND_WINDOW_ID = "org.eclipse.ui.contexts.dialogAndWindow";

    public void testOneContext() throws Exception {
        IEclipseContext appContext = E4Application.createDefaultContext();
        this.defineContexts(appContext);
        EContextService cs = (EContextService)appContext.get(EContextService.class.getName());
        ContextTest.assertEquals((int)0, (int)cs.getActiveContextIds().size());
        cs.activateContext(DIALOG_AND_WINDOW_ID);
        ContextTest.assertEquals((int)1, (int)cs.getActiveContextIds().size());
    }

    public void testTwoContexts() throws Exception {
        IEclipseContext appContext = E4Application.createDefaultContext();
        this.defineContexts(appContext);
        EContextService cs = (EContextService)appContext.get(EContextService.class.getName());
        ContextTest.assertEquals((int)0, (int)cs.getActiveContextIds().size());
        IEclipseContext window = appContext.createChild("windowContext");
        appContext.set("activeChildContext", (Object)window);
        EContextService windowService = (EContextService)window.get(EContextService.class.getName());
        cs.activateContext(DIALOG_AND_WINDOW_ID);
        ContextTest.assertEquals((int)1, (int)cs.getActiveContextIds().size());
        ContextTest.assertEquals((int)1, (int)windowService.getActiveContextIds().size());
        cs.deactivateContext(DIALOG_AND_WINDOW_ID);
        ContextTest.assertEquals((int)0, (int)windowService.getActiveContextIds().size());
        ContextTest.assertEquals((int)0, (int)cs.getActiveContextIds().size());
    }

    public void testTwoContextsBottom() throws Exception {
        IEclipseContext appContext = E4Application.createDefaultContext();
        this.defineContexts(appContext);
        EContextService cs = (EContextService)appContext.get(EContextService.class.getName());
        ContextTest.assertEquals((int)0, (int)cs.getActiveContextIds().size());
        IEclipseContext window = appContext.createChild("windowContext");
        appContext.set("activeChildContext", (Object)window);
        EContextService windowService = (EContextService)window.get(EContextService.class.getName());
        windowService.activateContext(DIALOG_AND_WINDOW_ID);
        ContextTest.assertEquals((int)1, (int)cs.getActiveContextIds().size());
        ContextTest.assertEquals((int)1, (int)windowService.getActiveContextIds().size());
        windowService.deactivateContext(DIALOG_AND_WINDOW_ID);
        ContextTest.assertEquals((int)0, (int)windowService.getActiveContextIds().size());
        ContextTest.assertEquals((int)0, (int)cs.getActiveContextIds().size());
        appContext.set("activeChildContext", null);
        cs.activateContext(DIALOG_AND_WINDOW_ID);
        ContextTest.assertEquals((int)1, (int)cs.getActiveContextIds().size());
        ContextTest.assertEquals((int)1, (int)windowService.getActiveContextIds().size());
        cs.deactivateContext(DIALOG_AND_WINDOW_ID);
        ContextTest.assertEquals((int)0, (int)windowService.getActiveContextIds().size());
        ContextTest.assertEquals((int)0, (int)cs.getActiveContextIds().size());
    }

    public void testThreeContexts() throws Exception {
        IEclipseContext appContext = E4Application.createDefaultContext();
        this.defineContexts(appContext);
        EContextService cs = (EContextService)appContext.get(EContextService.class.getName());
        IEclipseContext window = appContext.createChild("windowContext");
        EContextService windowService = (EContextService)window.get(EContextService.class.getName());
        IEclipseContext dialog = appContext.createChild("dialogContext");
        appContext.set("activeChildContext", (Object)dialog);
        EContextService dialogService = (EContextService)dialog.get(EContextService.class.getName());
        cs.activateContext(DIALOG_AND_WINDOW_ID);
        windowService.activateContext(WINDOW_ID);
        ContextTest.assertEquals((int)1, (int)cs.getActiveContextIds().size());
        ContextTest.assertEquals((int)1, (int)dialogService.getActiveContextIds().size());
        ContextTest.assertEquals((int)2, (int)windowService.getActiveContextIds().size());
        dialogService.activateContext(DIALOG_ID);
        ContextTest.assertEquals((int)2, (int)cs.getActiveContextIds().size());
        ContextTest.assertEquals((int)2, (int)dialogService.getActiveContextIds().size());
        ContextTest.assertEquals((int)2, (int)windowService.getActiveContextIds().size());
        ContextTest.assertTrue((boolean)cs.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        ContextTest.assertTrue((boolean)cs.getActiveContextIds().contains(DIALOG_ID));
        ContextTest.assertFalse((boolean)cs.getActiveContextIds().contains(WINDOW_ID));
        ContextTest.assertTrue((boolean)dialogService.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        ContextTest.assertTrue((boolean)dialogService.getActiveContextIds().contains(DIALOG_ID));
        ContextTest.assertFalse((boolean)dialogService.getActiveContextIds().contains(WINDOW_ID));
        ContextTest.assertTrue((boolean)windowService.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        ContextTest.assertFalse((boolean)windowService.getActiveContextIds().contains(DIALOG_ID));
        ContextTest.assertTrue((boolean)windowService.getActiveContextIds().contains(WINDOW_ID));
        appContext.set("activeChildContext", (Object)window);
        ContextTest.assertEquals((int)2, (int)cs.getActiveContextIds().size());
        ContextTest.assertEquals((int)2, (int)dialogService.getActiveContextIds().size());
        ContextTest.assertEquals((int)2, (int)windowService.getActiveContextIds().size());
        ContextTest.assertTrue((boolean)cs.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        ContextTest.assertFalse((boolean)cs.getActiveContextIds().contains(DIALOG_ID));
        ContextTest.assertTrue((boolean)cs.getActiveContextIds().contains(WINDOW_ID));
        ContextTest.assertTrue((boolean)dialogService.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        ContextTest.assertTrue((boolean)dialogService.getActiveContextIds().contains(DIALOG_ID));
        ContextTest.assertFalse((boolean)dialogService.getActiveContextIds().contains(WINDOW_ID));
        ContextTest.assertTrue((boolean)windowService.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        ContextTest.assertFalse((boolean)windowService.getActiveContextIds().contains(DIALOG_ID));
        ContextTest.assertTrue((boolean)windowService.getActiveContextIds().contains(WINDOW_ID));
    }

    private void defineContexts(IEclipseContext appContext) {
        EContextService cs = (EContextService)appContext.get(EContextService.class.getName());
        Context daw = cs.getContext(DIALOG_AND_WINDOW_ID);
        daw.define("Dialog and Window", null, null);
        Context d = cs.getContext(DIALOG_ID);
        d.define("Dialog", null, DIALOG_AND_WINDOW_ID);
        Context w = cs.getContext(WINDOW_ID);
        w.define("Window", null, DIALOG_AND_WINDOW_ID);
    }
}

