/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;

public class HandlerTest
extends TestCase {
    private static final String HELP_COMMAND_ID = "org.eclipse.ui.commands.help";
    private static final String HELP_COMMAND1_ID = "org.eclipse.ui.commands.help1";

    public void testOneCommand() throws Exception {
        IEclipseContext appContext = E4Application.createDefaultContext();
        this.defineCommands(appContext);
        ParameterizedCommand helpCommand = this.getCommand(appContext, HELP_COMMAND_ID);
        ParameterizedCommand help1Command = this.getCommand(appContext, HELP_COMMAND1_ID);
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)appContext.get(EHandlerService.class.getName());
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        ECommandService cmdService = (ECommandService)appContext.get(ECommandService.class.getName());
        Command command = cmdService.getCommand(HELP_COMMAND_ID);
        HandlerTest.assertEquals((String)HELP_COMMAND_ID, (String)command.getId());
        HandlerTest.assertEquals((Object)HELP_COMMAND_ID, (Object)service.executeHandler(helpCommand));
        HandlerTest.assertTrue((boolean)handler.ran);
        HandlerTest.assertNull((Object)service.executeHandler(help1Command));
    }

    public void testTwoCommands() throws Exception {
        IEclipseContext appContext = E4Application.createDefaultContext();
        this.defineCommands(appContext);
        ParameterizedCommand helpCommand = this.getCommand(appContext, HELP_COMMAND_ID);
        ParameterizedCommand help1Command = this.getCommand(appContext, HELP_COMMAND1_ID);
        EHandlerService service = (EHandlerService)appContext.get(EHandlerService.class.getName());
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        TestHandler handler1 = new TestHandler(false, HELP_COMMAND1_ID);
        service.activateHandler(HELP_COMMAND1_ID, (Object)handler1);
        HandlerTest.assertEquals((Object)HELP_COMMAND_ID, (Object)service.executeHandler(helpCommand));
        HandlerTest.assertNull((Object)service.executeHandler(help1Command));
        HandlerTest.assertFalse((boolean)handler1.ran);
        handler1.canRun = true;
        HandlerTest.assertEquals((Object)HELP_COMMAND1_ID, (Object)service.executeHandler(help1Command));
        HandlerTest.assertTrue((boolean)handler1.ran);
    }

    public void testTwoHandlers() throws Exception {
        IEclipseContext appContext = E4Application.createDefaultContext();
        this.defineCommands(appContext);
        ParameterizedCommand helpCommand = this.getCommand(appContext, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)appContext.get(EHandlerService.class.getName());
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        IEclipseContext window = appContext.createChild("windowContext");
        appContext.set("activeChildContext", (Object)window);
        EHandlerService windowService = (EHandlerService)window.get(EHandlerService.class.getName());
        String windowRC = "org.eclipse.ui.commands.help.window";
        TestHandler windowHandler = new TestHandler(false, windowRC);
        windowService.activateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        HandlerTest.assertNull((Object)service.executeHandler(helpCommand));
        HandlerTest.assertFalse((boolean)windowHandler.ran);
        HandlerTest.assertFalse((boolean)handler.ran);
        windowHandler.canRun = true;
        HandlerTest.assertEquals((Object)windowRC, (Object)service.executeHandler(helpCommand));
        HandlerTest.assertTrue((boolean)windowHandler.ran);
        HandlerTest.assertFalse((boolean)handler.ran);
    }

    private ParameterizedCommand getCommand(IEclipseContext appContext, String commandId) {
        ECommandService cs = (ECommandService)appContext.get(ECommandService.class.getName());
        Command cmd = cs.getCommand(commandId);
        return new ParameterizedCommand(cmd, null);
    }

    public void testCanExecute() throws Exception {
        IEclipseContext appContext = E4Application.createDefaultContext();
        this.defineCommands(appContext);
        ParameterizedCommand helpCommand = this.getCommand(appContext, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)appContext.get(EHandlerService.class.getName());
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        IEclipseContext window = appContext.createChild("windowContext");
        appContext.set("activeChildContext", (Object)window);
        EHandlerService windowService = (EHandlerService)window.get(EHandlerService.class.getName());
        String windowRC = "org.eclipse.ui.commands.help.window";
        TestHandler windowHandler = new TestHandler(false, windowRC);
        windowService.activateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        HandlerTest.assertFalse((boolean)windowService.canExecute(helpCommand));
        windowHandler.canRun = true;
        HandlerTest.assertTrue((boolean)windowService.canExecute(helpCommand));
        windowHandler.canRun = false;
        HandlerTest.assertFalse((boolean)windowService.canExecute(helpCommand));
        windowService.deactivateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        HandlerTest.assertTrue((boolean)windowService.canExecute(helpCommand));
    }

    public void testThreeContexts() throws Exception {
        IEclipseContext appContext = E4Application.createDefaultContext();
        this.defineCommands(appContext);
        ParameterizedCommand helpCommand = this.getCommand(appContext, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)appContext.get(EHandlerService.class.getName());
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        IEclipseContext window = appContext.createChild("windowContext");
        appContext.set("activeChildContext", (Object)window);
        EHandlerService windowService = (EHandlerService)window.get(EHandlerService.class.getName());
        String windowRC = "org.eclipse.ui.commands.help.window";
        TestHandler windowHandler = new TestHandler(true, windowRC);
        windowService.activateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        HandlerTest.assertEquals((Object)windowRC, (Object)service.executeHandler(helpCommand));
        IEclipseContext dialog = appContext.createChild("dialogContext");
        appContext.set("activeChildContext", (Object)dialog);
        HandlerTest.assertEquals((Object)HELP_COMMAND_ID, (Object)service.executeHandler(helpCommand));
        appContext.set("activeChildContext", (Object)window);
        HandlerTest.assertEquals((Object)windowRC, (Object)service.executeHandler(helpCommand));
    }

    public void testDifferentExecutionContexts() throws Exception {
        IEclipseContext appContext = E4Application.createDefaultContext();
        this.defineCommands(appContext);
        ParameterizedCommand helpCommand = this.getCommand(appContext, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)appContext.get(EHandlerService.class.getName());
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        IEclipseContext window = appContext.createChild("windowContext");
        appContext.set("activeChildContext", (Object)window);
        EHandlerService windowService = (EHandlerService)window.get(EHandlerService.class.getName());
        String windowRC = "org.eclipse.ui.commands.help.window";
        TestHandler windowHandler = new TestHandler(true, windowRC);
        windowService.activateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        HandlerTest.assertEquals((Object)windowRC, (Object)service.executeHandler(helpCommand));
        HandlerTest.assertEquals((Object)windowRC, (Object)windowService.executeHandler(helpCommand));
        IEclipseContext dialog = appContext.createChild("dialogContext");
        EHandlerService dialogService = (EHandlerService)dialog.get(EHandlerService.class.getName());
        HandlerTest.assertEquals((Object)HELP_COMMAND_ID, (Object)dialogService.executeHandler(helpCommand));
    }

    private void defineCommands(IEclipseContext appContext) {
        ECommandService cmdService = (ECommandService)appContext.get(ECommandService.class.getName());
        Category category = cmdService.defineCategory("cat.org.eclipse.ui.commands.help", "Help Category", null);
        cmdService.defineCommand(HELP_COMMAND_ID, "Help Command", null, category, null);
        cmdService.defineCommand(HELP_COMMAND1_ID, "Help 1 Command", null, category, null);
    }

    public static class TestHandler {
        boolean ran = false;
        boolean canRun;
        String rc;

        public TestHandler(boolean c, String ret) {
            this.canRun = c;
            this.rc = ret;
        }

        @CanExecute
        public boolean canExecute() {
            return this.canRun;
        }

        @Execute
        public Object execute() {
            this.ran = true;
            return this.rc;
        }
    }
}

