/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XWTTestCase
extends TestCase {
    protected Control root;

    protected void runTest(URL url, Runnable ... checkActions) {
        this.runTest(url, new HashMap<String, Object>(), checkActions);
    }

    protected void runTest(URL url, Object dataContext, Runnable ... checkActions) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.DataContext", dataContext);
        this.runTest(url, options, checkActions);
    }

    protected void runTest(URL url, Map<String, Object> options, Runnable ... checkActions) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                this.root = XWT.loadWithOptions((URL)url, options);
                XWTTestCase.assertNotNull((Object)this.root);
                Shell shell = this.root.getShell();
                shell.open();
                Display display = shell.getDisplay();
                try {
                    Runnable[] runnableArray = checkActions;
                    int n = checkActions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Runnable runnable = runnableArray[n2];
                        while (display.readAndDispatch()) {
                        }
                        display.syncExec(runnable);
                        while (display.readAndDispatch()) {
                        }
                        while (display.readAndDispatch()) {
                        }
                        ++n2;
                    }
                    XWTTestCase.assertFalse((boolean)this.root.isDisposed());
                }
                finally {
                    try {
                        shell.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                while (display.readAndDispatch()) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                XWTTestCase.fail((String)e.getMessage());
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected void runDebugTest(URL url, Runnable prepareAction, Runnable checkAction1) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                this.root = XWT.load((URL)url);
                XWTTestCase.assertNotNull((Object)this.root);
                Shell shell = this.root.getShell();
                shell.open();
                Display display = shell.getDisplay();
                if (prepareAction != null) {
                    display.asyncExec(prepareAction);
                }
                while (!display.isDisposed()) {
                    display.readAndDispatch();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                XWTTestCase.fail((String)e.getMessage());
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected void selectButton(Button button) {
        this.selectButton(button, true);
    }

    protected void checkVisibility(String name, Class<? extends Control> type) {
        Object element = XWT.findElementByName((Object)this.root, (String)name);
        if (element == null) {
            XWTTestCase.fail((String)(String.valueOf(name) + " is not found."));
        }
        XWTTestCase.assertTrue((boolean)type.isInstance(element));
        Control section = (Control)element;
        XWTTestCase.assertTrue((boolean)section.getVisible());
    }

    protected void checkChildren(String name, String path, int number) {
        Object element = XWT.findElementByName((Object)this.root, (String)name);
        if (path != null) {
            try {
                Method method = element.getClass().getMethod("get" + path, new Class[0]);
                if (method == null) {
                    XWTTestCase.fail((String)("Property " + path + " is not found in " + element.getClass().getName()));
                }
                element = method.invoke(element, new Object[0]);
                XWTTestCase.assertTrue((boolean)Composite.class.isInstance(element));
            }
            catch (Exception e) {
                e.printStackTrace();
                XWTTestCase.fail((String)e.getMessage());
            }
        }
        XWTTestCase.assertTrue((boolean)Composite.class.isInstance(element));
        Composite composite = (Composite)element;
        XWTTestCase.assertEquals((int)composite.getChildren().length, (int)number);
    }

    protected void checkChildren(String name, int number) {
        this.checkChildren(name, null, number);
    }

    protected void selectButton(Button button, boolean selection) {
        Point size = button.getSize();
        Display display = button.getDisplay();
        Event upEvent = new Event();
        upEvent.widget = button;
        upEvent.button = 1;
        upEvent.type = 4;
        upEvent.x = size.x / 2;
        upEvent.y = size.y / 2;
        display.post(upEvent);
        button.setSelection(selection);
        button.notifyListeners(13, upEvent);
    }

    protected void assertText(String name, String value) {
        Object element = XWT.findElementByName((Object)this.root, (String)name);
        XWTTestCase.assertTrue((boolean)(element instanceof Text));
        Text text = (Text)element;
        XWTTestCase.assertEquals((String)value, (String)text.getText());
    }

    protected void setText(String name, String value) {
        Object element = XWT.findElementByName((Object)this.root, (String)name);
        XWTTestCase.assertTrue((boolean)(element instanceof Text));
        Text text = (Text)element;
        text.setText(value);
    }

    protected void assertEqualsArray(Object[] source, Object[] target) {
        XWTTestCase.assertEquals((int)source.length, (int)target.length);
        int i = 0;
        while (i < source.length) {
            XWTTestCase.assertEquals((Object)source[i], (Object)target[i]);
            ++i;
        }
    }
}

