/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.web;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.ui.internal.web.Base64;
import org.eclipse.e4.ui.internal.web.E4BrowserUtil;
import org.eclipse.e4.ui.web.BrowserRPC;
import org.eclipse.e4.ui.web.BrowserRPCHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public abstract class BrowserEditorPart
extends EditorPart {
    private Browser browser;
    private BrowserRPC browserRPC;
    private boolean isDirty;
    private List menuItems = new ArrayList(3);
    private SaveableProxy saveable;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.browser = new Browser(parent, 0);
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                BrowserEditorPart view = BrowserEditorPart.this.openWindow(event);
                if (view != null) {
                    event.browser = view.getBrowser();
                    event.required = true;
                }
            }
        });
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                BrowserEditorPart.this.isDirty = false;
                BrowserEditorPart.this.getEditorSite().getPage().closeEditor((IEditorPart)BrowserEditorPart.this, true);
            }
        });
        this.browserRPC = new BrowserRPC(this.browser);
        this.saveable = new SaveableProxy(this.browser);
        this.browserRPC.addRPCHandler("dialogs", new BrowserRPCHandler(){

            public Object handle(Browser browser, Object[] args) {
                if ("confirm".equals(args[1])) {
                    IEditorSite site = BrowserEditorPart.this.getEditorSite();
                    String title = "Confirmation - " + BrowserEditorPart.this.getTitle();
                    return MessageDialog.openConfirm((Shell)site.getShell(), (String)title, (String)((String)args[2]));
                }
                return null;
            }

            public void dispose() {
            }
        });
        this.browserRPC.addRPCHandler("clipboard", new BrowserRPCHandler(){

            public Object handle(Browser browser, Object[] args) {
                File file;
                FileTransfer ft;
                Clipboard cb;
                String[] files;
                if ("getContents".equals(args[1]) && (files = (String[])(cb = new Clipboard(browser.getDisplay())).getContents((Transfer)(ft = FileTransfer.getInstance()))).length > 0 && (file = new File(files[0])).exists()) {
                    try {
                        byte[] data = E4BrowserUtil.getBytesFromFile(file);
                        byte[] encoded = Base64.encode(data);
                        return new String(encoded);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }

            public void dispose() {
            }
        });
        this.browserRPC.addRPCHandler("menus", new BrowserRPCHandler(){

            public Object handle(Browser browser, Object[] args) {
                if ("addContextMenuItem".equals(args[1])) {
                    BrowserEditorPart.this.menuItems.add(new MenuItemProxy((String)args[2], (String)args[3]));
                }
                return null;
            }

            public void dispose() {
            }
        });
        this.browserRPC.addRPCHandler("status", new BrowserRPCHandler(){

            public Object handle(Browser browser, Object[] args) {
                if ("setMessage".equals(args[1])) {
                    IStatusLineManager slm = BrowserEditorPart.this.getEditorSite().getActionBars().getStatusLineManager();
                    slm.setMessage((String)args[2]);
                } else if ("setDirty".equals(args[1])) {
                    BrowserEditorPart.this.isDirty = (Boolean)args[2];
                    BrowserEditorPart.this.firePropertyChange(257);
                }
                return null;
            }

            public void dispose() {
            }
        });
        this.browserRPC.addRPCHandler("saveable", new BrowserRPCHandler(){

            public Object handle(Browser browser, Object[] args) {
                if ("promptToSaveOnClose".equals(args[1])) {
                    BrowserEditorPart.this.saveable.setPromptCallback((String)args[2]);
                } else if ("doSave".equals(args[1])) {
                    BrowserEditorPart.this.saveable.setDoSaveCallback((String)args[2]);
                }
                return null;
            }

            public void dispose() {
            }
        });
        this.configureBrowser(this.browser);
        this.hookContextMenu();
    }

    protected void configureBrowser(Browser b) {
    }

    protected BrowserEditorPart openWindow(WindowEvent event) {
        BrowserEditorPart view = null;
        try {
            view = (BrowserEditorPart)this.getEditorSite().getPage().openEditor(this.getNewWindowEditorInput(event), this.getNewWindowEditorId(event));
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return view;
    }

    protected String getNewWindowEditorId(WindowEvent event) {
        return this.getSite().getId();
    }

    protected abstract IEditorInput getNewWindowEditorInput(WindowEvent var1);

    public void setUrl(String url) {
        this.browser.setUrl(url);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Iterator itr = BrowserEditorPart.this.menuItems.iterator();
                while (itr.hasNext()) {
                    MenuItemProxy mi = (MenuItemProxy)itr.next();
                    Action action = new Action(this, mi.getLabel(), mi){
                        final /* synthetic */ 8 this$1;
                        private final /* synthetic */ MenuItemProxy val$mi;
                        {
                            this.this$1 = var1_1;
                            this.val$mi = menuItemProxy;
                        }

                        public void run() {
                            BrowserEditorPart.access$4(8.access$0(this.this$1)).execute(this.val$mi.getCallback());
                        }
                    };
                    manager.add((IAction)action);
                }
            }

            static /* synthetic */ BrowserEditorPart access$0(8 var0) {
                return var0.BrowserEditorPart.this;
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.browser);
        this.browser.setMenu(menu);
    }

    public int promptToSaveOnClose() {
        return this.saveable.promptToSaveOnClose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.saveable.doSave(monitor);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    static /* synthetic */ Browser access$4(BrowserEditorPart browserEditorPart) {
        return browserEditorPart.browser;
    }

    private class MenuItemProxy {
        private String label;
        private String callback;

        public MenuItemProxy(String label, String callback) {
            this.label = label;
            this.callback = callback;
        }

        public String getLabel() {
            return this.label;
        }

        public String getCallback() {
            return this.callback;
        }
    }

    private class SaveableProxy {
        private String promptCallback;
        private String dosaveCallback;
        private Browser browser;

        public SaveableProxy(Browser browser) {
            this.browser = browser;
        }

        public void setPromptCallback(String promptCallback) {
            this.promptCallback = promptCallback;
        }

        public void setDoSaveCallback(String dosaveCallback) {
            this.dosaveCallback = dosaveCallback;
        }

        public int promptToSaveOnClose() {
            Double i;
            if (this.promptCallback != null && (i = (Double)this.browser.evaluate(this.promptCallback)) != null) {
                return i.intValue();
            }
            return 3;
        }

        public void doSave(IProgressMonitor monitor) {
            if (this.dosaveCallback != null) {
                this.browser.execute(this.dosaveCallback);
            }
        }
    }
}

