/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;

public class InjectionOrderTest
extends TestCase {
    public void testSpecialMethodOnFailure() {
        IEclipseContext appContext = EclipseContextFactory.create();
        boolean exception = false;
        try {
            ContextInjectionFactory.make(InjectUnsatisfied.class, (IEclipseContext)appContext);
        }
        catch (InjectionException injectionException) {
            exception = true;
        }
        InjectionOrderTest.assertTrue((boolean)exception);
        appContext.dispose();
        InjectionOrderTest.assertEquals((int)0, (int)InjectUnsatisfied.count);
    }

    public static interface ITestObject {
    }

    public static class InjectUnsatisfied {
        @Inject
        ITestObject object;
        public static int count = 0;

        @PostConstruct
        public void postConstruct() {
            ++count;
            this.object.toString();
        }

        @PreDestroy
        public void preDestroy() {
            ++count;
            this.object.toString();
        }
    }
}

