/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.FindImportElementDialog;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditListProperty;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.IViewerValueProperty;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ControlFactory {
    public static void createXMIId(Composite parent, AbstractComponentEditor editor) {
        Label l = new Label(parent, 0);
        l.setText("XMI:ID");
        l.setLayoutData((Object)new GridData(128));
        final Text t = new Text(parent, 2048);
        t.setEditable(false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        editor.getMaster().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                String v;
                Resource res;
                Object val = event.diff.getNewValue();
                if (val != null && val instanceof EObject && !t.isDisposed() && (res = ((EObject)val).eResource()) instanceof E4XMIResource && (v = ((E4XMIResource)res).getID((EObject)val)) != null && v.trim().length() > 0) {
                    t.setText(v);
                }
            }
        });
    }

    public static void createMapProperties(Composite parent, final AbstractComponentEditor editor, String label, final EStructuralFeature feature, int vIndent) {
        Label l = new Label(parent, 0);
        l.setText(label);
        GridData gd = new GridData(3, 1, false, false);
        gd.verticalIndent = vIndent;
        l.setLayoutData((Object)gd);
        final TableViewer tableviewer = new TableViewer(parent);
        tableviewer.getTable().setHeaderVisible(true);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        tableviewer.setContentProvider((IContentProvider)cp);
        gd = new GridData(768);
        gd.heightHint = 80;
        gd.verticalIndent = vIndent;
        tableviewer.getControl().setLayoutData((Object)gd);
        TableViewerColumn column = new TableViewerColumn(tableviewer, 0);
        column.getColumn().setText(Messages.ControlFactory_Key);
        column.getColumn().setWidth(200);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return (String)entry.getKey();
            }
        });
        column = new TableViewerColumn(tableviewer, 0);
        column.getColumn().setText(Messages.ControlFactory_Value);
        column.getColumn().setWidth(200);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return (String)entry.getValue();
            }
        });
        final TextCellEditor cellEditor = new TextCellEditor((Composite)tableviewer.getTable());
        column.setEditingSupport(new EditingSupport((ColumnViewer)tableviewer){

            protected void setValue(Object element, Object value) {
                Command cmd = SetCommand.create((EditingDomain)editor.getEditingDomain(), (Object)element, (Object)ApplicationPackageImpl.Literals.STRING_TO_STRING_MAP__KEY, (Object)(value.toString().trim().length() == 0 ? null : value.toString()));
                if (cmd.canExecute()) {
                    editor.getEditingDomain().getCommandStack().execute(cmd);
                }
            }

            protected Object getValue(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return entry.getValue() == null ? "" : (String)entry.getValue();
            }

            protected CellEditor getCellEditor(Object element) {
                return cellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        IEMFEditListProperty prop = EMFEditProperties.list((EditingDomain)editor.getEditingDomain(), (EStructuralFeature)feature);
        tableviewer.setInput((Object)prop.observeDetail((IObservableValue)editor.getMaster()));
        final Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayoutData((Object)new GridData(4, 3, false, false));
        GridLayout gl = new GridLayout();
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        buttonComp.setLayout((Layout)gl);
        Button b = new Button(buttonComp, 0x800008);
        b.setText(Messages.ModelTooling_Common_AddEllipsis);
        b.setImage(editor.getImage(b.getDisplay(), 1));
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Dialog dialog = new Dialog(buttonComp.getShell()){
                    private Text key;
                    private Text value;

                    protected Control createDialogArea(Composite parent) {
                        this.getShell().setText(Messages.ControlFactory_KeyValueShellTitle);
                        Composite comp = (Composite)super.createDialogArea(parent);
                        Composite container = new Composite(comp, 0);
                        container.setLayout((Layout)new GridLayout(2, false));
                        container.setLayoutData((Object)new GridData(1808));
                        Label l = new Label(container, 0);
                        l.setText(Messages.ControlFactory_Key);
                        this.key = new Text(container, 2048);
                        this.key.setLayoutData((Object)new GridData(768));
                        l = new Label(container, 0);
                        l.setText(Messages.ControlFactory_Value);
                        this.value = new Text(container, 2048);
                        this.value.setLayoutData((Object)new GridData(768));
                        return comp;
                    }

                    protected void okPressed() {
                        if (this.key.getText().trim().length() > 0) {
                            BasicEMap.Entry entry = (BasicEMap.Entry)ApplicationFactoryImpl.eINSTANCE.createStringToStringMap();
                            entry.setHash(this.key.hashCode());
                            entry.setKey((Object)this.key.getText());
                            entry.setValue(this.value.getText().trim().length() > 0 ? this.value.getText() : null);
                            Command cmd = AddCommand.create((EditingDomain)editor.getEditingDomain(), (Object)editor.getMaster().getValue(), (Object)feature, (Object)entry);
                            if (cmd.canExecute()) {
                                editor.getEditingDomain().getCommandStack().execute(cmd);
                                super.okPressed();
                            }
                        }
                    }
                };
                dialog.open();
            }
        });
        b = new Button(buttonComp, 0x800008);
        b.setText(Messages.ModelTooling_Common_Remove);
        b.setImage(editor.getImage(b.getDisplay(), 2));
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Command cmd;
                IStructuredSelection selection = (IStructuredSelection)tableviewer.getSelection();
                if (!selection.isEmpty() && (cmd = RemoveCommand.create((EditingDomain)editor.getEditingDomain(), (Object)editor.getMaster().getValue(), (Object)feature, (Collection)selection.toList())).canExecute()) {
                    editor.getEditingDomain().getCommandStack().execute(cmd);
                }
            }
        });
    }

    public static void createTextField(Composite parent, String label, IObservableValue master, EMFDataBindingContext context, IWidgetValueProperty textProp, IEMFEditValueProperty modelProp) {
        Label l = new Label(parent, 0);
        l.setText(label);
        l.setLayoutData((Object)new GridData(128));
        Text t = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), modelProp.observeDetail(master));
    }

    public static void createFindImport(Composite parent, final AbstractComponentEditor editor, EMFDataBindingContext context) {
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        Label l = new Label(parent, 0);
        l.setText(Messages.ModelTooling_Common_RefId);
        l.setLayoutData((Object)new GridData(128));
        Text t = new Text(parent, 2048);
        GridData gd = new GridData(768);
        t.setLayoutData((Object)gd);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)editor.getEditingDomain(), (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID).observeDetail((IObservableValue)editor.getMaster()));
        final Button b = new Button(parent, 0x800008);
        b.setText(Messages.ModelTooling_Common_FindEllipsis);
        b.setImage(editor.getImage(t.getDisplay(), 0));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindImportElementDialog dialog = new FindImportElementDialog(b.getShell(), editor, (EObject)editor.getMaster().getValue());
                dialog.open();
            }
        });
    }

    public static void createSelectedElement(Composite parent, AbstractComponentEditor editor, final EMFDataBindingContext context, String label) {
        Label l = new Label(parent, 0);
        l.setText(label);
        l.setLayoutData((Object)new GridData(128));
        ComboViewer viewer = new ComboViewer(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        viewer.getControl().setLayoutData((Object)gd);
        IEMFEditListProperty listProp = EMFEditProperties.list((EditingDomain)editor.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN);
        IEMFEditValueProperty labelProp = EMFEditProperties.value((EditingDomain)editor.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_LABEL__LABEL);
        IEMFEditValueProperty idProp = EMFEditProperties.value((EditingDomain)editor.getEditingDomain(), (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID);
        IViewerValueProperty vProp = ViewerProperties.singleSelection();
        final Binding[] binding = new Binding[1];
        IViewerObservableValue uiObs = vProp.observe((Viewer)viewer);
        IObservableValue mObs = EMFEditProperties.value((EditingDomain)editor.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__SELECTED_ELEMENT).observeDetail((IObservableValue)editor.getMaster());
        editor.getMaster().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                if (binding[0] != null) {
                    binding[0].dispose();
                }
            }
        });
        final IObservableList list = listProp.observeDetail((IObservableValue)editor.getMaster());
        ObservableListContentProvider cp = new ObservableListContentProvider();
        viewer.setContentProvider((IContentProvider)cp);
        IObservableMap[] attributeMaps = new IObservableMap[]{labelProp.observeDetail(cp.getKnownElements()), idProp.observeDetail(cp.getKnownElements())};
        viewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(attributeMaps){

            public String getText(Object element) {
                MApplicationElement appEl;
                MUILabel label;
                EObject o = (EObject)element;
                String rv = o.eClass().getName();
                if (element instanceof MUILabel && !Util.isNullOrEmpty((label = (MUILabel)element).getLabel())) {
                    return String.valueOf(rv) + " - " + label.getLabel().trim();
                }
                if (element instanceof MApplicationElement && !Util.isNullOrEmpty((appEl = (MApplicationElement)element).getElementId())) {
                    return String.valueOf(rv) + " - " + appEl.getElementId();
                }
                return String.valueOf(rv) + "[" + list.indexOf(element) + "]";
            }
        });
        viewer.setInput((Object)list);
        editor.getMaster().addValueChangeListener(new IValueChangeListener((IObservableValue)uiObs, mObs){
            private final /* synthetic */ IObservableValue val$uiObs;
            private final /* synthetic */ IObservableValue val$mObs;
            {
                this.val$uiObs = iObservableValue;
                this.val$mObs = iObservableValue2;
            }

            public void handleValueChange(ValueChangeEvent event) {
                binding[0] = context.bindValue(this.val$uiObs, this.val$mObs);
            }
        });
    }

    public static void createStringListWidget(Composite parent, final AbstractComponentEditor editor, String label, final EStructuralFeature feature, int vIndent) {
        Label l = new Label(parent, 0);
        l.setText(label);
        GridData gd = new GridData(3, 1, false, false);
        gd.verticalIndent = vIndent;
        l.setLayoutData((Object)gd);
        final Text t = new Text(parent, 2048);
        gd = new GridData(4, 1, true, false);
        gd.verticalIndent = vIndent;
        t.setLayoutData((Object)gd);
        t.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10) {
                    ControlFactory.handleAddText(editor, (EStructuralFeature)UiPackageImpl.Literals.CONTEXT__VARIABLES, t);
                }
            }
        });
        Button b = new Button(parent, 0x800008);
        b.setText(Messages.ModelTooling_Common_Add);
        b.setImage(editor.getImage(b.getDisplay(), 1));
        gd = new GridData(4, 2, false, false);
        gd.verticalIndent = vIndent;
        b.setLayoutData((Object)gd);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ControlFactory.handleAddText(editor, feature, t);
            }
        });
        new Label(parent, 0);
        final TableViewer viewer = new TableViewer(parent);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        gd = new GridData(768);
        gd.heightHint = 150;
        viewer.getControl().setLayoutData((Object)gd);
        IEMFListProperty prop = EMFProperties.list((EStructuralFeature)feature);
        viewer.setInput((Object)prop.observeDetail((IObservableValue)editor.getMaster()));
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayoutData((Object)new GridData(4, 3, false, false));
        GridLayout gl = new GridLayout();
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        buttonComp.setLayout((Layout)gl);
        b = new Button(buttonComp, 0x800008);
        b.setText(Messages.ModelTooling_Common_Up);
        b.setImage(editor.getImage(b.getDisplay(), 3));
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection s;
                if (!viewer.getSelection().isEmpty() && (s = (IStructuredSelection)viewer.getSelection()).size() == 1) {
                    Command cmd;
                    Object obj = s.getFirstElement();
                    MContext container = (MContext)editor.getMaster().getValue();
                    int idx = container.getVariables().indexOf(obj) - 1;
                    if (idx >= 0 && (cmd = MoveCommand.create((EditingDomain)editor.getEditingDomain(), (Object)editor.getMaster().getValue(), (Object)feature, (Object)obj, (int)idx)).canExecute()) {
                        editor.getEditingDomain().getCommandStack().execute(cmd);
                        viewer.setSelection((ISelection)new StructuredSelection(obj));
                    }
                }
            }
        });
        b = new Button(buttonComp, 0x800008);
        b.setText(Messages.ModelTooling_Common_Down);
        b.setImage(editor.getImage(b.getDisplay(), 4));
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection s;
                if (!viewer.getSelection().isEmpty() && (s = (IStructuredSelection)viewer.getSelection()).size() == 1) {
                    Command cmd;
                    Object obj = s.getFirstElement();
                    MApplication container = (MApplication)editor.getMaster().getValue();
                    int idx = container.getVariables().indexOf(obj) + 1;
                    if (idx < container.getVariables().size() && (cmd = MoveCommand.create((EditingDomain)editor.getEditingDomain(), (Object)editor.getMaster().getValue(), (Object)feature, (Object)obj, (int)idx)).canExecute()) {
                        editor.getEditingDomain().getCommandStack().execute(cmd);
                        viewer.setSelection((ISelection)new StructuredSelection(obj));
                    }
                }
            }
        });
        b = new Button(buttonComp, 0x800008);
        b.setText(Messages.ModelTooling_Common_Remove);
        b.setImage(editor.getImage(b.getDisplay(), 2));
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!viewer.getSelection().isEmpty()) {
                    MContext el = (MContext)editor.getMaster().getValue();
                    List ids = ((IStructuredSelection)viewer.getSelection()).toList();
                    Command cmd = RemoveCommand.create((EditingDomain)editor.getEditingDomain(), (Object)el, (Object)feature, (Collection)ids);
                    if (cmd.canExecute()) {
                        editor.getEditingDomain().getCommandStack().execute(cmd);
                        if (el.getVariables().size() > 0) {
                            viewer.setSelection((ISelection)new StructuredSelection(el.getVariables().get(0)));
                        }
                    }
                }
            }
        });
    }

    private static void handleAddText(AbstractComponentEditor editor, EStructuralFeature feature, Text tagText) {
        if (tagText.getText().trim().length() > 0) {
            String[] tags = tagText.getText().split(";");
            int i = 0;
            while (i < tags.length) {
                tags[i] = tags[i].trim();
                ++i;
            }
            MApplicationElement appEl = (MApplicationElement)editor.getMaster().getValue();
            Command cmd = AddCommand.create((EditingDomain)editor.getEditingDomain(), (Object)appEl, (Object)feature, Arrays.asList(tags));
            if (cmd.canExecute()) {
                editor.getEditingDomain().getCommandStack().execute(cmd);
            }
            tagText.setText("");
        }
    }

    public static void createCheckBox(Composite parent, String label, IObservableValue master, EMFDataBindingContext context, IWidgetValueProperty selectionProp, IEMFEditValueProperty modelProp) {
        Label l = new Label(parent, 0);
        l.setText(label);
        l.setLayoutData((Object)new GridData(128));
        Button t = new Button(parent, 32);
        t.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        context.bindValue((IObservableValue)selectionProp.observe((Widget)t), modelProp.observeDetail(master));
    }
}

