/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;

public class Bug308317Test
extends TestCase {
    protected IEclipseContext appContext;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
    }

    protected void tearDown() throws Exception {
        if (this.appContext instanceof IDisposable) {
            this.appContext.dispose();
        }
    }

    public void testBug308317() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack stackA = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stackA);
        window.setSelectedElement((MUIElement)stackA);
        MPartStack stackB = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stackB);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        stackA.getChildren().add(partA);
        stackA.setSelectedElement((MUIElement)partA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        stackB.getChildren().add(partB);
        stackB.setSelectedElement((MUIElement)partB);
        IEclipseContext windowContext = this.appContext.createChild();
        windowContext.set(MWindow.class.getName(), (Object)window);
        window.setContext(windowContext);
        IEclipseContext partContextA = windowContext.createChild();
        partContextA.set(MPart.class.getName(), (Object)partA);
        partA.setContext(partContextA);
        IEclipseContext partContextB = windowContext.createChild();
        partContextB.set(MPart.class.getName(), (Object)partB);
        partB.setContext(partContextB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        PartConsumer getter = (PartConsumer)ContextInjectionFactory.make(PartConsumer.class, (IEclipseContext)window.getContext());
        window.getContext().set("activeChildContext", (Object)partA.getContext());
        Bug308317Test.assertEquals((Object)partA, (Object)getter.part);
        window.getContext().set("activeChildContext", (Object)partB.getContext());
        Bug308317Test.assertEquals((Object)partB, (Object)getter.part);
        window.getContext().set("activeChildContext", (Object)partA.getContext());
        Bug308317Test.assertEquals((Object)partA, (Object)getter.part);
        window.getContext().set("activeChildContext", null);
        Bug308317Test.assertEquals(null, (Object)getter.part);
        partB.getContext().dispose();
        window.getContext().set("activeChildContext", (Object)partA.getContext());
        Bug308317Test.assertEquals((Object)partA, (Object)getter.part);
    }

    static class PartConsumer {
        private MPart part;

        PartConsumer() {
        }

        @Inject
        void setPart(@Optional @Named(value="e4ActivePart") MPart part) {
            this.part = part;
            if (part != null) {
                part.getContext().get("abc");
            }
        }
    }
}

