/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.editor.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTMaps;
import org.eclipse.e4.xwt.converters.StringToInteger;
import org.eclipse.e4.xwt.metadata.IEvent;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;
import org.eclipse.e4.xwt.tools.ui.designer.core.style.SWTStyles;
import org.eclipse.e4.xwt.tools.ui.designer.core.style.StyleGroup;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.StringUtil;
import org.eclipse.e4.xwt.tools.ui.designer.editor.text.assist.XWTSelectionCompletionProposal;
import org.eclipse.e4.xwt.tools.ui.designer.resources.ImageShop;
import org.eclipse.e4.xwt.utils.NamedColorsUtil;
import org.eclipse.e4.xwt.utils.ResourceManager;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWTContentAssistProcessor
extends XMLContentAssistProcessor {
    static XWTSelectionCompletionProposal[] booleanProposals;
    static XWTSelectionCompletionProposal[] colorsProposals;
    static XWTSelectionCompletionProposal[] stylesProposals;
    static XWTSelectionCompletionProposal[] acceleratorsProposals;
    protected Comparator<ICompletionProposal> comparator = new Comparator<ICompletionProposal>(){

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            return o1.getDisplayString().compareTo(o2.getDisplayString());
        }
    };

    static synchronized XWTSelectionCompletionProposal[] getBooleanProposals() {
        if (booleanProposals == null) {
            String[] values = new String[]{"true", "false"};
            Image image = ImageShop.get("icons/full/obj16/attribute_obj.gif");
            booleanProposals = new XWTSelectionCompletionProposal[values.length];
            int j = 0;
            while (j < values.length) {
                String pattern = "\"" + values[j] + "\"";
                XWTContentAssistProcessor.booleanProposals[j] = new XWTSelectionCompletionProposal(pattern, 0, 0, 1, values[j].length(), image, values[j], null, null);
                ++j;
            }
        }
        return booleanProposals;
    }

    static synchronized XWTSelectionCompletionProposal[] getColorsProposals() {
        if (colorsProposals == null) {
            Collection names = XWTMaps.getColorKeys();
            String[] colorNames = NamedColorsUtil.getColorNames();
            colorsProposals = new XWTSelectionCompletionProposal[names.size() + colorNames.length];
            int i = 0;
            for (String colorStr : names) {
                Color color = ResourceManager.resources.getColor(colorStr);
                XWTSelectionCompletionProposal p = XWTContentAssistProcessor.createColorProposal(color, colorStr);
                if (p == null) continue;
                XWTContentAssistProcessor.colorsProposals[i++] = p;
            }
            String[] stringArray = colorNames;
            int n = colorNames.length;
            int n2 = 0;
            while (n2 < n) {
                String colorName = stringArray[n2];
                Color color = ResourceManager.resources.getColor(colorName);
                XWTSelectionCompletionProposal p = XWTContentAssistProcessor.createColorProposal(color, colorName);
                if (p != null) {
                    XWTContentAssistProcessor.colorsProposals[i++] = p;
                }
                ++n2;
            }
        }
        return colorsProposals;
    }

    static XWTSelectionCompletionProposal createColorProposal(Color color, String colorName) {
        if (color != null) {
            String pattern = "\"" + colorName + "\"";
            Image image = new Image(null, 16, 16);
            GC gc = new GC((Drawable)image);
            gc.setBackground(color);
            gc.fillRectangle(0, 0, 16, 16);
            gc.dispose();
            return new XWTSelectionCompletionProposal(pattern, 0, 0, 1, colorName.length(), image, colorName, null, null);
        }
        return null;
    }

    static synchronized XWTSelectionCompletionProposal[] getStylesProposals(Class<?> type, String value) {
        stylesProposals = null;
        Image image = ImageShop.get("/icons/full/tools/element.png");
        if (value.startsWith("\"")) {
            value = value.replace("\"", "");
        }
        Collection<String> names = XWTContentAssistProcessor.getStyleFromWidgetName(type, value);
        stylesProposals = new XWTSelectionCompletionProposal[names.size()];
        int i = 0;
        String replaceString = "";
        for (String string : names) {
            replaceString = XWTContentAssistProcessor.getStyleCorrectReplacedPattern(string, value, type);
            String pattern = "\"" + replaceString + "\"";
            XWTContentAssistProcessor.stylesProposals[i++] = new XWTSelectionCompletionProposal(pattern, 0, 0, 1, replaceString.length(), image, string, null, null);
        }
        return stylesProposals;
    }

    private static String getStyleCorrectReplacedPattern(String newStyle, String oldStyle, Class<?> type) {
        StyleGroup[] styles;
        int masterStyle = 0;
        String shouldDelete = "";
        boolean isInSameGroup = false;
        ArrayList<String> oldValues = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(oldStyle, "|");
        while (stk.hasMoreTokens()) {
            oldValues.add(stk.nextToken().trim());
        }
        masterStyle = XWTContentAssistProcessor.getMasterStyleIntegerFromStyles(oldValues);
        StyleGroup[] styleGroupArray = styles = SWTStyles.getStyles(type);
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            StyleGroup styleGroup = styleGroupArray[n2];
            if (styleGroup.match(masterStyle) && (isInSameGroup = Arrays.asList(items = styleGroup.getStyles()).contains(newStyle))) {
                if (!"default".equals(styleGroup.getGroupName())) {
                    String[] stringArray = items;
                    int n3 = items.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String item = stringArray[n4];
                        for (String oldValue : oldValues) {
                            if (!XWTContentAssistProcessor.equalsIgnoreSWTStyle(oldValue, item)) continue;
                            shouldDelete = oldValue;
                        }
                        ++n4;
                    }
                }
                oldValues.remove(shouldDelete);
                oldValues.add(newStyle);
            }
            ++n2;
        }
        String newStyleValue = StringUtil.format((Object[])oldValues.toArray(new String[oldValues.size()]), (String)"|");
        return newStyleValue;
    }

    private static boolean equalsIgnoreSWTStyle(String value, String object) {
        if (value.contains("SWT.")) {
            value = value.replace("SWT.", "");
        }
        if (object.contains("SWT.")) {
            object = object.replace("SWT.", "");
        }
        return value.equalsIgnoreCase(object);
    }

    private static int getMasterStyleIntegerFromStyles(List<String> oldValues) {
        int masterStyle = 0;
        if (oldValues != null && oldValues.size() != 0) {
            for (String oldValue : oldValues) {
                masterStyle |= ((Integer)StringToInteger.instance.convert((Object)oldValue)).intValue();
            }
        }
        return masterStyle;
    }

    private static Collection<String> getStyleFromWidgetName(Class<?> type, String value) {
        StyleGroup[] styles;
        HashSet<String> collection = new HashSet<String>();
        collection.clear();
        int masterStyle = 0;
        ArrayList<String> oldValues = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(value, "|");
        while (stk.hasMoreTokens()) {
            oldValues.add(stk.nextToken().trim());
        }
        masterStyle = XWTContentAssistProcessor.getMasterStyleIntegerFromStyles(oldValues);
        StyleGroup[] styleGroupArray = styles = SWTStyles.getStyles(type);
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            StyleGroup styleGroup = styleGroupArray[n2];
            if (styleGroup.match(masterStyle)) {
                String[] items;
                String[] stringArray = items = styleGroup.getStyles();
                int n3 = items.length;
                int n4 = 0;
                while (n4 < n3) {
                    String item = stringArray[n4];
                    if (!XWTContentAssistProcessor.isContainsTheElement(oldValues, item)) {
                        collection.add(item);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return collection;
    }

    private static boolean isContainsTheElement(List<String> oldValues, String style) {
        if (style.contains("SWT.")) {
            style = style.replace("SWT.", "");
        }
        for (String oldValue : oldValues) {
            if (oldValue.contains("SWT.")) {
                oldValue = oldValue.replace("SWT.", "");
            }
            if (!oldValue.equalsIgnoreCase(style)) continue;
            return true;
        }
        return false;
    }

    static synchronized XWTSelectionCompletionProposal[] getAcceleratorsProposals() {
        if (acceleratorsProposals == null) {
            Collection names = XWTMaps.getAcceleratorKeys();
            acceleratorsProposals = new XWTSelectionCompletionProposal[names.size()];
            int i = 0;
            for (String string : names) {
                String pattern = "\"" + string + "\"";
                XWTContentAssistProcessor.acceleratorsProposals[i++] = new XWTSelectionCompletionProposal(pattern, 0, 0, 1, string.length(), null, string, null, null);
            }
        }
        return acceleratorsProposals;
    }

    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest) {
        this.addXAMLPropertyNameProposals(contentAssistRequest);
        super.addAttributeNameProposals(contentAssistRequest);
    }

    /*
     * WARNING - void declaration
     */
    private void addXAMLPropertyNameProposals(ContentAssistRequest contentAssistRequest) {
        ArrayList<XWTSelectionCompletionProposal> proposalCollector = new ArrayList<XWTSelectionCompletionProposal>();
        ArrayList<XWTSelectionCompletionProposal> macrosCollector = new ArrayList<XWTSelectionCompletionProposal>();
        Node node = contentAssistRequest.getNode();
        String name = this.getNodeName(node);
        HashSet<String> existing = new HashSet<String>();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            Node attributeNode = namedNodeMap.item(i);
            String attributeName = attributeNode.getNodeName();
            existing.add(attributeName);
            ++i;
        }
        boolean useProposalList = !contentAssistRequest.shouldSeparate();
        int offset = contentAssistRequest.getReplacementBeginPosition();
        int replacementLength = contentAssistRequest.getReplacementLength();
        IDocument document = this.fTextViewer.getDocument();
        String prefixed = null;
        try {
            prefixed = document.get(offset, replacementLength).toLowerCase();
        }
        catch (BadLocationException badLocationException) {}
        IMetaclass metaclass = XWT.getMetaclass((String)name, (String)node.getNamespaceURI());
        if (metaclass != null) {
            IEvent[] events;
            void var16_22;
            IProperty[] properties;
            IProperty[] iPropertyArray = properties = metaclass.getProperties();
            int n = properties.length;
            boolean n2 = false;
            while (var16_22 < n) {
                IProperty property = iPropertyArray[var16_22];
                Class propertyType = property.getType();
                if (propertyType == null || !Control.class.isAssignableFrom(propertyType)) {
                    String propertyName = property.getName();
                    if ((prefixed == null || propertyName.toLowerCase().startsWith(prefixed)) && !existing.contains(propertyName)) {
                        String defaultValueString = "";
                        if (propertyName.equalsIgnoreCase("style")) {
                            propertyName = "x:style";
                            defaultValueString = "SWT.NONE";
                        }
                        String replacementString = String.valueOf(propertyName) + "=\"" + defaultValueString + "\" ";
                        Image image = ImageShop.get("org.eclipse.jdt.ui.field_public_obj.gif");
                        XWTSelectionCompletionProposal proposal = new XWTSelectionCompletionProposal(replacementString, offset, replacementLength, propertyName.length() + 2, defaultValueString.length(), image, propertyName, null, "Property: " + propertyName);
                        if (useProposalList) {
                            proposalCollector.add(proposal);
                        } else {
                            macrosCollector.add(proposal);
                        }
                    }
                }
                ++var16_22;
            }
            IEvent[] iEventArray = events = metaclass.getEvents();
            int n3 = events.length;
            n = 0;
            while (n < n3) {
                IEvent iEvent = iEventArray[n];
                String eventName = iEvent.getName();
                if (prefixed == null || eventName.toLowerCase().startsWith(prefixed)) {
                    eventName = String.valueOf(Character.toUpperCase(eventName.charAt(0))) + eventName.substring(1) + "Event";
                    if (iEvent.getName() != null && iEvent.getName().equals("Loaded")) {
                        eventName = "Loaded";
                    }
                    if (!existing.contains(eventName)) {
                        String replacementString = String.valueOf(eventName) + "=\"perform" + eventName + "\" ";
                        Image image = ImageShop.get("/icons/full/tools/event.png");
                        XWTSelectionCompletionProposal proposal = new XWTSelectionCompletionProposal(replacementString, offset, replacementLength, eventName.length() + 2, eventName.length() + "perform".length(), image, eventName, null, "Event: " + eventName);
                        if (useProposalList) {
                            proposalCollector.add(proposal);
                        } else {
                            macrosCollector.add(proposal);
                        }
                    }
                }
                ++n;
            }
        }
        Node parentNode = node.getParentNode();
        String parentName = this.getNodeName(parentNode);
        try {
            IMetaclass iMetaclass = XWT.getMetaclass((String)parentName, (String)parentNode.getNamespaceURI());
        }
        catch (Exception exception) {}
        Collections.sort(proposalCollector, this.comparator);
        Collections.sort(macrosCollector, this.comparator);
        for (ICompletionProposal iCompletionProposal : proposalCollector) {
            contentAssistRequest.addProposal(iCompletionProposal);
        }
        for (ICompletionProposal iCompletionProposal : macrosCollector) {
            contentAssistRequest.addMacro(iCompletionProposal);
        }
    }

    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest) {
        this.addXAMLPropertyValueProposals(contentAssistRequest);
        super.addAttributeValueProposals(contentAssistRequest);
    }

    /*
     * WARNING - void declaration
     */
    private void addXAMLPropertyValueProposals(ContentAssistRequest contentAssistRequest) {
        ArrayList<XWTSelectionCompletionProposal> proposalCollector = new ArrayList<XWTSelectionCompletionProposal>();
        ArrayList<XWTSelectionCompletionProposal> macrosCollector = new ArrayList<XWTSelectionCompletionProposal>();
        IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
        String namespaceURI = node.getNamespaceURI();
        String name = this.getNodeName((Node)node);
        String value = "";
        IMetaclass metaclass = XWT.getMetaclass((String)name, (String)namespaceURI);
        StyledText textWidget = this.fTextViewer.getTextWidget();
        if (metaclass != null) {
            IStructuredDocumentRegion iStructuredDocumentRegion = node.getFirstStructuredDocumentRegion();
            ITextRegionList openRegions = iStructuredDocumentRegion.getRegions();
            int m = openRegions.indexOf(contentAssistRequest.getRegion());
            int n = openRegions.indexOf(contentAssistRequest.getRegion());
            if (m < 0 || n < 0) {
                return;
            }
            ITextRegion nameRegion = null;
            ITextRegion valueRegion = null;
            while (m >= 0) {
                if ((nameRegion = openRegions.get(m--)).getType() == "XML_TAG_ATTRIBUTE_NAME") break;
            }
            while (n >= 0) {
                if ((valueRegion = openRegions.get(n--)).getType() == "XML_TAG_ATTRIBUTE_VALUE") break;
            }
            if (valueRegion != null) {
                value = iStructuredDocumentRegion.getText(valueRegion);
            }
            if (nameRegion != null) {
                Object pattern;
                this.getCMElementDeclaration((Node)node);
                String attributeName = iStructuredDocumentRegion.getText(nameRegion);
                IProperty property = metaclass.findProperty(attributeName);
                if (attributeName.equalsIgnoreCase("x:style") || property != null) {
                    int offset = contentAssistRequest.getReplacementBeginPosition();
                    int replacementLength = contentAssistRequest.getReplacementLength();
                    boolean useProposalList = !contentAssistRequest.shouldSeparate();
                    String prefixed = null;
                    String prefixedQuote = "";
                    boolean fullValue = true;
                    try {
                        int caretIndex = textWidget.getCaretOffset();
                        IDocument iDocument = this.fTextViewer.getDocument();
                        prefixed = iDocument.get(offset, caretIndex - offset).toLowerCase();
                        if (prefixed.equals("\"\"")) {
                            prefixed = null;
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                    if (prefixed != null) {
                        prefixedQuote = String.valueOf(prefixed) + "\"";
                        fullValue = false;
                    }
                    if (attributeName.equalsIgnoreCase("accelerator")) {
                        void var25_40;
                        XWTSelectionCompletionProposal[] proposals = XWTContentAssistProcessor.getAcceleratorsProposals();
                        boolean bl = false;
                        while (var25_40 < proposals.length) {
                            Iterator pattern2 = proposals[var25_40].getReplacementString();
                            if (prefixed == null || (((String)((Object)pattern2)).toLowerCase().startsWith(prefixed) || fullValue) && !prefixedQuote.equalsIgnoreCase((String)((Object)pattern2))) {
                                proposals[var25_40].setReplacementOffset(offset);
                                proposals[var25_40].setReplacementLength(replacementLength);
                                if (useProposalList) {
                                    proposalCollector.add(proposals[var25_40]);
                                } else {
                                    macrosCollector.add(proposals[var25_40]);
                                }
                            }
                            ++var25_40;
                        }
                        Collections.sort(proposalCollector, this.comparator);
                        Collections.sort(macrosCollector, this.comparator);
                        for (ICompletionProposal iCompletionProposal : proposalCollector) {
                            contentAssistRequest.addProposal(iCompletionProposal);
                        }
                        for (ICompletionProposal iCompletionProposal : macrosCollector) {
                            contentAssistRequest.addMacro(iCompletionProposal);
                        }
                        return;
                    }
                    if (attributeName.equalsIgnoreCase("x:style")) {
                        void var25_44;
                        XWTSelectionCompletionProposal[] proposals = XWTContentAssistProcessor.getStylesProposals(metaclass.getType(), value);
                        boolean bl = false;
                        while (var25_44 < proposals.length) {
                            Iterator pattern3 = proposals[var25_44].getReplacementString();
                            if (prefixed == null || (((String)((Object)pattern3)).toLowerCase().startsWith(prefixed) || fullValue) && !prefixedQuote.equalsIgnoreCase((String)((Object)pattern3))) {
                                proposals[var25_44].setReplacementOffset(offset);
                                proposals[var25_44].setReplacementLength(replacementLength);
                                if (useProposalList) {
                                    proposalCollector.add(proposals[var25_44]);
                                } else {
                                    macrosCollector.add(proposals[var25_44]);
                                }
                            }
                            ++var25_44;
                        }
                        Collections.sort(proposalCollector, this.comparator);
                        Collections.sort(macrosCollector, this.comparator);
                        for (ICompletionProposal iCompletionProposal : proposalCollector) {
                            contentAssistRequest.addProposal(iCompletionProposal);
                        }
                        for (ICompletionProposal iCompletionProposal : macrosCollector) {
                            contentAssistRequest.addMacro(iCompletionProposal);
                        }
                        return;
                    }
                    Class javaType = property.getType();
                    if (javaType == Boolean.class || javaType == Boolean.TYPE) {
                        XWTSelectionCompletionProposal[] xWTSelectionCompletionProposalArray = XWTContentAssistProcessor.getBooleanProposals();
                        int j = 0;
                        while (j < xWTSelectionCompletionProposalArray.length) {
                            String pattern4 = xWTSelectionCompletionProposalArray[j].getReplacementString();
                            if (prefixed == null || (pattern4.toLowerCase().startsWith(prefixed) || fullValue) && !prefixedQuote.equalsIgnoreCase(pattern4)) {
                                xWTSelectionCompletionProposalArray[j].setReplacementOffset(offset);
                                xWTSelectionCompletionProposalArray[j].setReplacementLength(replacementLength);
                                if (useProposalList) {
                                    proposalCollector.add(xWTSelectionCompletionProposalArray[j]);
                                } else {
                                    macrosCollector.add(xWTSelectionCompletionProposalArray[j]);
                                }
                            }
                            ++j;
                        }
                    } else if (javaType != null && javaType.isEnum()) {
                        T[] TArray = javaType.getEnumConstants();
                        IConverter converter = XWT.findConvertor((Class)javaType, String.class);
                        int j = 0;
                        while (j < TArray.length) {
                            String valueString = "";
                            if (converter != null) {
                                Object stringValue = converter.convert(TArray[j]);
                                if (stringValue != null) {
                                    valueString = stringValue.toString();
                                }
                            } else {
                                valueString = TArray[j].toString();
                            }
                            pattern = "\"" + valueString + "\"";
                            if (prefixed == null || (((String)pattern).toLowerCase().startsWith(prefixed) || fullValue) && !prefixedQuote.equalsIgnoreCase((String)pattern)) {
                                Image image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/enum.gif");
                                XWTSelectionCompletionProposal proposal = new XWTSelectionCompletionProposal((String)pattern, offset, replacementLength, 1, valueString.length(), image, valueString, null, null);
                                if (useProposalList) {
                                    proposalCollector.add(proposal);
                                } else {
                                    macrosCollector.add(proposal);
                                }
                            }
                            ++j;
                        }
                    } else if (javaType.isAssignableFrom(Color.class)) {
                        XWTSelectionCompletionProposal[] xWTSelectionCompletionProposalArray = XWTContentAssistProcessor.getColorsProposals();
                        pattern = xWTSelectionCompletionProposalArray;
                        int valueString = xWTSelectionCompletionProposalArray.length;
                        int j = 0;
                        while (j < valueString) {
                            XWTSelectionCompletionProposal proposal = pattern[j];
                            String pattern5 = proposal.getReplacementString();
                            if (prefixed == null || (pattern5.toLowerCase().startsWith(prefixed) || fullValue) && !prefixedQuote.equalsIgnoreCase(pattern5)) {
                                proposal.setReplacementOffset(offset);
                                proposal.setReplacementLength(replacementLength);
                                if (useProposalList) {
                                    proposalCollector.add(proposal);
                                } else {
                                    macrosCollector.add(proposal);
                                }
                            }
                            ++j;
                        }
                    }
                } else {
                    metaclass.getEvents();
                    JavaProject javaProject = (JavaProject)textWidget.getData("javaProject");
                    String className = (String)textWidget.getData("className");
                    List<String> javaMethods = this.getJavaMethods(javaProject, className);
                    int offset = contentAssistRequest.getReplacementBeginPosition();
                    int caretIndex = textWidget.getCaretOffset();
                    IDocument document = this.fTextViewer.getDocument();
                    String prefixed = null;
                    try {
                        prefixed = document.get(offset + 1, caretIndex - offset - 1);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    int n2 = contentAssistRequest.getReplacementLength();
                    boolean useProposalList = !contentAssistRequest.shouldSeparate();
                    for (String valueString : javaMethods) {
                        if (valueString.equals(prefixed)) continue;
                        pattern = "\"" + valueString + "\"";
                        XWTSelectionCompletionProposal proposal = new XWTSelectionCompletionProposal((String)pattern, offset, n2, 1, valueString.length(), null, valueString, null, null);
                        if (useProposalList) {
                            proposalCollector.add(proposal);
                            continue;
                        }
                        macrosCollector.add(proposal);
                    }
                }
            }
        }
        Collections.sort(proposalCollector, this.comparator);
        Collections.sort(macrosCollector, this.comparator);
        for (ICompletionProposal iCompletionProposal : proposalCollector) {
            contentAssistRequest.addProposal(iCompletionProposal);
        }
        for (ICompletionProposal iCompletionProposal : macrosCollector) {
            contentAssistRequest.addMacro(iCompletionProposal);
        }
    }

    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition) {
        this.addXAMLElementProposals(contentAssistRequest);
        super.addTagInsertionProposals(contentAssistRequest, childPosition);
    }

    private void addXAMLElementProposals(ContentAssistRequest contentAssistRequest) {
        XWTSelectionCompletionProposal proposal4;
        XWTSelectionCompletionProposal layoutProposal;
        String layout;
        ArrayList<XWTSelectionCompletionProposal> proposalCollector = new ArrayList<XWTSelectionCompletionProposal>();
        ArrayList<XWTSelectionCompletionProposal> macrosCollector = new ArrayList<XWTSelectionCompletionProposal>();
        ArrayList<String> addedTags = new ArrayList<String>();
        boolean useProposalList = !contentAssistRequest.shouldSeparate();
        int offset = contentAssistRequest.getReplacementBeginPosition();
        int replacementLength = contentAssistRequest.getReplacementLength();
        String prefixed = null;
        try {
            IDocument document = this.fTextViewer.getDocument();
            prefixed = document.get(offset, replacementLength).toLowerCase();
        }
        catch (BadLocationException badLocationException) {}
        Node node = contentAssistRequest.getNode();
        if (node == null) {
            return;
        }
        if (node instanceof IDOMText) {
            IDOMText text = (IDOMText)node;
            offset = text.getStartOffset();
            replacementLength = text.getLength();
            try {
                IDocument document = this.fTextViewer.getDocument();
                prefixed = document.get(offset, replacementLength).trim().toLowerCase();
            }
            catch (BadLocationException badLocationException) {}
        } else if (node instanceof IDOMNode) {
            IDOMNode domNode = (IDOMNode)node;
            NodeList children = domNode.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node node2 = children.item(i);
                if (node2 instanceof IDOMText) {
                    IDOMText text = (IDOMText)node2;
                    offset = text.getStartOffset();
                    replacementLength = text.getLength();
                    try {
                        IDocument document = this.fTextViewer.getDocument();
                        prefixed = document.get(offset, replacementLength).trim().toLowerCase();
                    }
                    catch (BadLocationException badLocationException) {}
                    break;
                }
                ++i;
            }
        }
        while (node.getNodeType() != 1) {
            if ((node = node.getParentNode()) != null) continue;
            return;
        }
        boolean containControls = false;
        String name = this.getNodeName(node);
        if (name.indexOf(".") != -1) {
            if (name.toLowerCase().endsWith(".control")) {
                name = "Control";
                containControls = true;
            } else {
                List<XWTSelectionCompletionProposal> proposals = this.createPropertyNodeProposals(name, offset, replacementLength);
                if (useProposalList) {
                    proposalCollector.addAll(proposals);
                } else {
                    macrosCollector.addAll(proposals);
                }
                Collections.sort(proposalCollector, this.comparator);
                Collections.sort(macrosCollector, this.comparator);
                for (ICompletionProposal iCompletionProposal : proposalCollector) {
                    contentAssistRequest.addProposal(iCompletionProposal);
                }
                for (ICompletionProposal iCompletionProposal : macrosCollector) {
                    contentAssistRequest.addMacro(iCompletionProposal);
                }
                return;
            }
        }
        IMetaclass metaclass = XWT.getMetaclass((String)name, (String)node.getNamespaceURI());
        String string = String.valueOf(name) + ".Resources";
        if (!addedTags.contains(string) && (prefixed == null || string.toLowerCase().startsWith(prefixed))) {
            addedTags.add(string);
            String pattern = "<" + string + "></" + string + ">";
            Image image = ImageShop.get("/icons/full/tools/resources.gif");
            XWTSelectionCompletionProposal proposal = new XWTSelectionCompletionProposal(pattern, offset, replacementLength, string.length() + 2, 0, image, string, null, "Element resources");
            if (useProposalList) {
                proposalCollector.add(proposal);
            } else {
                macrosCollector.add(proposal);
            }
        }
        if (!addedTags.contains(layout = String.valueOf(name) + ".layout") && (prefixed == null || layout.startsWith(prefixed)) && (layoutProposal = this.createLayoutProposal(metaclass, layout, offset, replacementLength)) != null) {
            if (useProposalList) {
                proposalCollector.add(layoutProposal);
            } else {
                macrosCollector.add(layoutProposal);
            }
        }
        String layoutData = String.valueOf(name) + ".layoutData";
        if (!addedTags.contains(layout) && (prefixed == null || layout.startsWith(prefixed)) && (proposal4 = this.createLayoutDataProposal(metaclass, layoutData, offset, replacementLength)) != null) {
            if (useProposalList) {
                proposalCollector.add(proposal4);
            } else {
                macrosCollector.add(proposal4);
            }
        }
        if (metaclass != null && (containControls || Composite.class.isAssignableFrom(metaclass.getType()))) {
            IMetaclass[] metaclasses;
            IMetaclass[] iMetaclassArray = metaclasses = XWT.getAllMetaclasses();
            int n = metaclasses.length;
            int n2 = 0;
            while (n2 < n) {
                IMetaclass type = iMetaclassArray[n2];
                if (Control.class.isAssignableFrom(type.getType()) && !type.isAbstract()) {
                    String typeName = type.getName();
                    if ((prefixed == null || typeName.toLowerCase().startsWith(prefixed)) && !addedTags.contains(typeName)) {
                        addedTags.add(typeName);
                        String pattern = "<" + typeName + "></" + typeName + ">";
                        Image image = ImageShop.get("/icons/full/tools/element.png");
                        XWTSelectionCompletionProposal proposal3 = new XWTSelectionCompletionProposal(pattern, offset, replacementLength, typeName.length() + 2, 0, image, typeName, null, null);
                        if (useProposalList) {
                            proposalCollector.add(proposal3);
                        } else {
                            macrosCollector.add(proposal3);
                        }
                    }
                }
                ++n2;
            }
        }
        Collections.sort(proposalCollector, this.comparator);
        Collections.sort(macrosCollector, this.comparator);
        for (XWTSelectionCompletionProposal proposal : proposalCollector) {
            contentAssistRequest.addProposal((ICompletionProposal)proposal);
        }
        for (XWTSelectionCompletionProposal proposal : macrosCollector) {
            contentAssistRequest.addMacro((ICompletionProposal)proposal);
        }
    }

    private List<XWTSelectionCompletionProposal> createPropertyNodeProposals(String tagName, int offset, int replacementLength) {
        ArrayList<XWTSelectionCompletionProposal> proposals;
        block4: {
            String property;
            block3: {
                int index = tagName.indexOf(".");
                if (index == -1) {
                    return Collections.emptyList();
                }
                proposals = new ArrayList<XWTSelectionCompletionProposal>();
                property = tagName.substring(index + 1);
                if (!"layout".equalsIgnoreCase(property)) break block3;
                String[] layouts = new String[]{"GridLayout", "FillLayout", "RowLayout", "StackLayout", "FormLayout"};
                int i = 0;
                while (i < layouts.length) {
                    String pattern = "<" + layouts[i] + "/>";
                    Image image = ImageShop.get("/icons/full/tools/element.png");
                    XWTSelectionCompletionProposal p = new XWTSelectionCompletionProposal(pattern, offset, replacementLength, layouts[i].length() + 2, 0, image, layouts[i], null, "Container Layout.");
                    proposals.add(p);
                    ++i;
                }
                break block4;
            }
            if (!"layoutData".equalsIgnoreCase(property)) break block4;
            String[] layoutDatas = new String[]{"GridData", "StackData", "FormData", "RowData"};
            int i = 0;
            while (i < layoutDatas.length) {
                String pattern = "<" + layoutDatas[i] + "></" + layoutDatas[i] + ">";
                Image image = ImageShop.get("/icons/full/tools/element.png");
                XWTSelectionCompletionProposal p = new XWTSelectionCompletionProposal(pattern, offset, replacementLength, layoutDatas[i].length() + 2, 0, image, layoutDatas[i], null, "Container LayoutData.");
                proposals.add(p);
                ++i;
            }
        }
        return proposals;
    }

    private XWTSelectionCompletionProposal createLayoutDataProposal(IMetaclass metaclass, String layoutData, int offset, int replacementLength) {
        if (!Control.class.isAssignableFrom(metaclass.getType())) {
            return null;
        }
        String pattern = "<" + layoutData + "></" + layoutData + ">";
        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.field_public_obj.gif");
        return new XWTSelectionCompletionProposal(pattern, offset, replacementLength, layoutData.length() + 2, 0, image, layoutData, null, "Control LayoutData.");
    }

    private XWTSelectionCompletionProposal createLayoutProposal(IMetaclass metaclass, String tagName, int offset, int replacementLength) {
        if (!Composite.class.isAssignableFrom(metaclass.getType())) {
            return null;
        }
        String pattern = "<" + tagName + "></" + tagName + ">";
        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.field_public_obj.gif");
        return new XWTSelectionCompletionProposal(pattern, offset, replacementLength, tagName.length() + 2, 0, image, tagName, null, "Container Layout.");
    }

    private String getNodeName(Node node) {
        String name = node.getNodeName();
        int index = name.indexOf(":");
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    private List<String> getJavaMethods(JavaProject javaProject, String className) {
        if (javaProject == null || className == null) {
            return Collections.emptyList();
        }
        ArrayList<String> javaMethods = new ArrayList<String>();
        try {
            IType type = javaProject.findType(className);
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                IMethod method = methods[i];
                String methodName = method.getElementName();
                javaMethods.add(methodName);
                ++i;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return javaMethods;
    }
}

