/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.databinding;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.IObservableValueListener;
import org.eclipse.e4.xwt.core.IEventHandler;
import org.eclipse.e4.xwt.databinding.XWTObservableValue;
import org.eclipse.e4.xwt.internal.utils.LoggerManager;
import org.eclipse.e4.xwt.internal.utils.ObservableValueManager;
import org.eclipse.e4.xwt.internal.utils.UserData;
import org.eclipse.e4.xwt.javabean.metadata.properties.EventProperty;
import org.eclipse.e4.xwt.metadata.IEvent;
import org.eclipse.swt.widgets.Event;

public class EventPropertyObservableValue
extends XWTObservableValue {
    private EventProperty property;

    public EventPropertyObservableValue(Object observed, EventProperty property) {
        super(Boolean.class, observed, property.getName());
        this.property = property;
        IEventHandler controller = UserData.findEventController(observed);
        if (controller == null) {
            controller = UserData.updateEventController(observed);
        }
        IEvent event = property.getEvent();
        IObservableValueListener manager = UserData.getObservableValueManager(observed);
        if (manager == null) {
            manager = new ObservableValueManager(observed);
            UserData.setObservableValueManager(observed, manager);
        }
        try {
            controller.setEvent(event, UserData.getWidget(observed), manager, property, IObservableValueListener.class.getDeclaredMethod("changeValueHandle", Object.class, Event.class));
            manager.registerValue(property, (IObservableValue)this);
        }
        catch (Exception e) {
            LoggerManager.log(e);
            return;
        }
    }

    protected void doSetApprovedValue(Object value) {
        UserData.setLocalData(this.getObserved(), this.property.getName(), value);
    }

    protected Object doGetValue() {
        return UserData.getLocalData(this.getObserved(), this.property.getName());
    }
}

