/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.animation;

import org.eclipse.nebula.animation.effects.MoveScrollBarEffect;
import org.eclipse.nebula.animation.movement.IMovement;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public class ScrollingSmoother {
    Scrollable component;
    ScrollBar verticalScrollBar;
    ScrollBar horizontalScrollBar;
    MoveScrollBarEffect me = null;
    IMovement movement = null;
    Listener mouseWheelListener = new Listener(){

        public void handleEvent(Event event) {
            int start;
            event.doit = false;
            ScrollBar currentScrollBar = ScrollingSmoother.this.getScrollbar(event);
            int end = start = currentScrollBar.getSelection();
            if (ScrollingSmoother.this.me != null) {
                start = ScrollingSmoother.this.me.getCurrent();
                end = ScrollingSmoother.this.me.getEnd();
            }
            if ((end -= event.count * currentScrollBar.getIncrement()) > currentScrollBar.getMaximum() - currentScrollBar.getThumb()) {
                end = currentScrollBar.getMaximum() - currentScrollBar.getThumb();
            }
            if (end < currentScrollBar.getMinimum()) {
                end = currentScrollBar.getMinimum();
            }
            ScrollingSmoother.this.startEffect(new MoveScrollBarEffect(currentScrollBar, start, end, 2000L, ScrollingSmoother.this.movement, null, null));
        }
    };
    SelectionListener cancelEffectIfUserSelection = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (!(e.data instanceof MoveScrollBarEffect)) {
                ScrollingSmoother.this.me = null;
            }
        }
    };

    public ScrollingSmoother(Scrollable c2, IMovement movement) {
        this.component = c2;
        this.verticalScrollBar = c2.getVerticalBar();
        this.horizontalScrollBar = c2.getHorizontalBar();
        this.movement = movement;
    }

    protected ScrollBar getScrollbar(Event event) {
        ScrollBar result = this.verticalScrollBar;
        if (result == null) {
            result = this.horizontalScrollBar;
        }
        return result;
    }

    public void smoothControl(boolean enable) {
        if (enable) {
            this.component.addListener(37, this.mouseWheelListener);
            if (this.verticalScrollBar != null) {
                this.verticalScrollBar.addSelectionListener(this.cancelEffectIfUserSelection);
            }
            if (this.horizontalScrollBar != null) {
                this.horizontalScrollBar.addSelectionListener(this.cancelEffectIfUserSelection);
            }
        } else {
            this.component.removeListener(37, this.mouseWheelListener);
            if (this.verticalScrollBar != null) {
                this.verticalScrollBar.removeSelectionListener(this.cancelEffectIfUserSelection);
            }
            if (this.horizontalScrollBar != null) {
                this.horizontalScrollBar.removeSelectionListener(this.cancelEffectIfUserSelection);
            }
        }
    }

    protected void startEffect(MoveScrollBarEffect moveScrollBarEffect) {
        MoveScrollBarEffect oldEffect = this.me;
        this.me = moveScrollBarEffect;
        if (oldEffect == null) {
            Display.getCurrent().syncExec(new Runnable(){

                public void run() {
                    if (ScrollingSmoother.this.me != null && !ScrollingSmoother.this.me.isDone()) {
                        ScrollingSmoother.this.me.doEffect();
                        Display.getCurrent().timerExec(10, (Runnable)this);
                    } else {
                        ScrollingSmoother.this.me = null;
                    }
                }
            });
        }
    }
}

