/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.css;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.engine.CSSErrorHandler;
import org.eclipse.e4.xwt.IStyle;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.css.CSSXWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCSSStyle
implements IStyle,
CSSErrorHandler {
    protected URL url;
    protected String content;
    private CSSEngine engine;
    private Display display;
    private Class<?> jfaceViewerClass;
    private Method getControl;

    public AbstractCSSStyle() {
        this((String)null);
    }

    public AbstractCSSStyle(URL url) {
        this.url = url;
        this.init();
    }

    public AbstractCSSStyle(String content) {
        this.content = content;
        this.init();
    }

    public AbstractCSSStyle(CSSEngine engine) {
        this.engine = engine;
        this.init();
    }

    private void init() {
        try {
            this.jfaceViewerClass = Class.forName("org.eclipse.jface.viewers.Viewer");
            this.getControl = this.jfaceViewerClass.getMethod("getControl", new Class[0]);
        }
        catch (Throwable throwable) {}
    }

    public void initializeIfNeed(Control control) {
        block11: {
            Display display = control.getDisplay();
            if (this.display != null && this.display == display) {
                return;
            }
            this.display = display;
            try {
                if (this.engine == null) {
                    this.engine = CSSXWT.getCSSEngine((Widget)control);
                    if (this.engine == null) {
                        this.engine = this.createCSSEngine(display);
                        CSSXWT.setCSSEngine(control.getShell(), this.engine);
                    }
                }
                this.engine.setErrorHandler((CSSErrorHandler)this);
                if (this.content != null) {
                    this.engine.parseStyleSheet((Reader)new StringReader(this.content));
                    break block11;
                }
                Method urlResolver = null;
                try {
                    Class<?> fileLocatorClass = this.loadClass("org.eclipse.core.runtime.FileLocator");
                    urlResolver = fileLocatorClass.getMethod("resolve", URL.class);
                }
                catch (Throwable throwable) {}
                URL contentURL = this.url;
                if (urlResolver != null) {
                    try {
                        contentURL = (URL)urlResolver.invoke(null, contentURL);
                    }
                    catch (Throwable throwable) {}
                }
                InputStream stream = contentURL.openStream();
                this.engine.parseStyleSheet(stream);
                stream.close();
            }
            catch (Throwable e) {
                System.err.println("Warning - could not initialize CSS styling : " + e.toString());
            }
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        if (this.url == url || this.url != null && this.url.equals(url)) {
            return;
        }
        this.url = url;
        this.reset();
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        if (this.content == content || this.content != null && this.content.equals(content)) {
            return;
        }
        this.content = content;
        this.reset();
    }

    protected void reset() {
        this.display = null;
        if (this.engine != null) {
            this.engine.reset();
            this.engine = null;
        }
    }

    public void applyStyle(Object target) {
        if (this.url == null && this.content == null && this.engine == null) {
            return;
        }
        String name = XWT.getElementName((Object)target);
        Control control = null;
        if (target instanceof Control) {
            control = (Control)target;
        } else if (this.getControl != null && this.jfaceViewerClass.isInstance(target)) {
            try {
                control = (Control)this.getControl.invoke(target, new Object[0]);
            }
            catch (Throwable e) {
                throw new XWTException(e);
            }
        }
        if (control != null) {
            this.initializeIfNeed(control);
            if (name != null) {
                control.setData("org.eclipse.e4.ui.css.id", (Object)name);
            }
            try {
                this.engine.applyStyles((Object)control, false, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public CSSEngine getEngine() {
        return this.engine;
    }

    public void error(Exception e) {
        throw new XWTException((Throwable)e);
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
    }

    protected abstract CSSEngine createCSSEngine(Display var1);
}

