/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts.debug.ui;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.debug.ui.AllocationRecorder;
import org.eclipse.e4.core.internal.contexts.debug.ui.ContextMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class ContextAllocation {
    private static final String EMPTY = "";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final TabFolder folder;
    private TabItem tabData;
    private Text text;
    private IEclipseContext selectedContext;

    public ContextAllocation(TabFolder folder) {
        this.folder = folder;
    }

    public void createControls() {
        this.tabData = new TabItem(this.folder, 0, 1);
        this.tabData.setText(ContextMessages.allocationsTab);
        Composite pageData = new Composite((Composite)this.folder, 0);
        this.tabData.setControl((Control)pageData);
        new Label(pageData, 0).setText(ContextMessages.allocationsLabel);
        this.text = new Text(pageData, 2824);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout rightPaneLayout = new GridLayout();
        rightPaneLayout.marginHeight = 0;
        rightPaneLayout.marginWidth = 0;
        pageData.setLayout((Layout)rightPaneLayout);
    }

    public void setInput(IEclipseContext newContext) {
        String traceText;
        if (newContext == this.selectedContext) {
            return;
        }
        this.selectedContext = newContext;
        if (this.selectedContext == null) {
            this.text.setText(EMPTY);
            return;
        }
        Throwable t = AllocationRecorder.getDefault().getTrace(this.selectedContext);
        if (t == null) {
            traceText = EMPTY;
        } else {
            StackTraceElement[] elements = t.getStackTrace();
            StringBuffer tmp = new StringBuffer();
            int i = 1;
            while (i < elements.length) {
                StackTraceElement stackTraceElement = elements[i];
                tmp.append(stackTraceElement.toString());
                tmp.append(NEW_LINE);
                ++i;
            }
            traceText = tmp.toString();
        }
        this.text.setText(traceText);
    }
}

