/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class EModelServiceTest
extends TestCase {
    private IEclipseContext applicationContext;
    private IPresentationEngine engine;

    protected void setUp() throws Exception {
        this.applicationContext = E4Application.createDefaultContext();
        super.setUp();
    }

    protected String getEngineURI() {
        return "platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.HeadlessContextPresentationEngine";
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.applicationContext.dispose();
    }

    private IPresentationEngine getEngine() {
        if (this.engine == null) {
            IContributionFactory contributionFactory = (IContributionFactory)this.applicationContext.get(IContributionFactory.class.getName());
            Object newEngine = contributionFactory.create(this.getEngineURI(), this.applicationContext);
            EModelServiceTest.assertTrue((boolean)(newEngine instanceof IPresentationEngine));
            this.applicationContext.set(IPresentationEngine.class.getName(), newEngine);
            this.engine = (IPresentationEngine)newEngine;
        }
        return this.engine;
    }

    public void testGetPerspectiveFor_RegularElement() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.applicationContext);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        this.getEngine().createGui((MUIElement)window);
        EModelService modelService = (EModelService)window.getContext().get(EModelService.class);
        MPerspective foundPerspective = modelService.getPerspectiveFor((MUIElement)partStack);
        EModelServiceTest.assertNotNull((Object)foundPerspective);
        EModelServiceTest.assertEquals((Object)perspective, (Object)foundPerspective);
    }

    public void testGetPerspectiveFor_SharedElement() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.applicationContext);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPlaceholder placeholder = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        perspective.getChildren().add(placeholder);
        perspective.setSelectedElement((MUIElement)placeholder);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        placeholder.setRef((MUIElement)partStack);
        partStack.setCurSharedRef(placeholder);
        this.getEngine().createGui((MUIElement)window);
        EModelService modelService = (EModelService)window.getContext().get(EModelService.class);
        MPerspective foundPerspective = modelService.getPerspectiveFor((MUIElement)partStack);
        EModelServiceTest.assertNotNull((Object)foundPerspective);
        EModelServiceTest.assertEquals((Object)perspective, (Object)foundPerspective);
    }

    public void testGetPerspectiveFor_SharedElement2() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.applicationContext);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPlaceholder placeholder = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        perspective.getChildren().add(placeholder);
        perspective.setSelectedElement((MUIElement)placeholder);
        MPartSashContainer partSashContainer = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        placeholder.setRef((MUIElement)partSashContainer);
        partSashContainer.setCurSharedRef(placeholder);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        partSashContainer.getChildren().add(partStack);
        partSashContainer.setSelectedElement((MUIElement)partStack);
        this.getEngine().createGui((MUIElement)window);
        EModelService modelService = (EModelService)window.getContext().get(EModelService.class);
        MPerspective foundPerspective = modelService.getPerspectiveFor((MUIElement)partStack);
        EModelServiceTest.assertNotNull((Object)foundPerspective);
        EModelServiceTest.assertEquals((Object)perspective, (Object)foundPerspective);
    }

    public void testBringToTop01() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.applicationContext);
        MWindow windowA = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(windowA);
        application.setSelectedElement((MUIElement)windowA);
        MWindow windowB = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(windowB);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EModelServiceTest.assertEquals((Object)windowA, (Object)application.getSelectedElement());
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        modelService.bringToTop((MUIElement)windowA);
        EModelServiceTest.assertEquals((Object)windowA, (Object)application.getSelectedElement());
        modelService.bringToTop((MUIElement)windowB);
        EModelServiceTest.assertEquals((Object)windowB, (Object)application.getSelectedElement());
    }

    public void testBringToTop02() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.applicationContext);
        MWindow windowA = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(windowA);
        application.setSelectedElement((MUIElement)windowA);
        MWindow windowB = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(windowB);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        windowB.getChildren().add(partB);
        windowB.setSelectedElement((MUIElement)partB);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EModelServiceTest.assertEquals((Object)windowA, (Object)application.getSelectedElement());
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        modelService.bringToTop((MUIElement)windowA);
        EModelServiceTest.assertEquals((Object)windowA, (Object)application.getSelectedElement());
        modelService.bringToTop((MUIElement)partB);
        EModelServiceTest.assertEquals((Object)windowA, (Object)application.getSelectedElement());
    }

    public void testBringToTop_Bug334411() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.applicationContext);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MWindow detachedWindow = BasicFactoryImpl.eINSTANCE.createWindow();
        detachedWindow.setToBeRendered(false);
        window.getWindows().add(detachedWindow);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setToBeRendered(false);
        detachedWindow.getChildren().add(part);
        this.getEngine().createGui((MUIElement)window);
        EModelServiceTest.assertEquals((Object)window, (Object)application.getSelectedElement());
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        modelService.bringToTop((MUIElement)part);
        EModelServiceTest.assertTrue((boolean)part.isToBeRendered());
        EModelServiceTest.assertTrue((boolean)detachedWindow.isToBeRendered());
    }

    public void testGetElementLocation_Bug331062_01() {
        MPerspective perspective = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        perspective.getChildren().add(part);
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        EModelServiceTest.assertEquals((int)0, (int)modelService.getElementLocation((MUIElement)part));
    }

    public void testGetElementLocation_Bug331062_02() {
        MPerspective perspective = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        MWindow detachedWindow = BasicFactoryImpl.eINSTANCE.createWindow();
        perspective.getWindows().add(detachedWindow);
        MWindow innerWindow = BasicFactoryImpl.eINSTANCE.createWindow();
        detachedWindow.getWindows().add(innerWindow);
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        EModelServiceTest.assertEquals((int)0, (int)modelService.getElementLocation((MUIElement)innerWindow));
    }
}

