/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerContributionTest
extends ModelReconcilerTest {
    private void testContribution_PersistedState(String applicationState, String userChange, String newApplicationState) {
        MApplication application = this.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.getPersistedState().put("testing", applicationState);
        window.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.getPersistedState().put("testing", userChange);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        part.getPersistedState().put("testing", newApplicationState);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerContributionTest.assertEquals((String)newApplicationState, (String)((String)part.getPersistedState().get("testing")));
        this.applyAll(deltas);
        if (applicationState == null) {
            if (userChange == null) {
                ModelReconcilerContributionTest.assertEquals((String)newApplicationState, (String)((String)part.getPersistedState().get("testing")));
            } else {
                ModelReconcilerContributionTest.assertEquals((String)userChange, (String)((String)part.getPersistedState().get("testing")));
            }
        } else if (userChange == null || !applicationState.equals(userChange)) {
            ModelReconcilerContributionTest.assertEquals((String)userChange, (String)((String)part.getPersistedState().get("testing")));
        } else {
            ModelReconcilerContributionTest.assertEquals((String)newApplicationState, (String)((String)part.getPersistedState().get("testing")));
        }
    }

    public void testContribution_PersistedState_NullNullNull() {
        this.testContribution_PersistedState(null, null, null);
    }

    public void testContribution_PersistedState_NullNullEmpty() {
        this.testContribution_PersistedState(null, null, "");
    }

    public void testContribution_PersistedState_NullNullString() {
        this.testContribution_PersistedState(null, null, "state");
    }

    public void testContribution_PersistedState_NullEmptyNull() {
        this.testContribution_PersistedState(null, "", null);
    }

    public void testContribution_PersistedState_NullEmptyEmpty() {
        this.testContribution_PersistedState(null, "", "");
    }

    public void testContribution_PersistedState_NullEmptyString() {
        this.testContribution_PersistedState(null, "", "state");
    }

    public void testContribution_PersistedState_NullStringNull() {
        this.testContribution_PersistedState(null, "state", null);
    }

    public void testContribution_PersistedState_NullStringEmpty() {
        this.testContribution_PersistedState(null, "state", "");
    }

    public void testContribution_PersistedState_NullStringString() {
        this.testContribution_PersistedState(null, "state", "state");
    }

    public void testContribution_PersistedState_NullStringString2() {
        this.testContribution_PersistedState(null, "state", "state2");
    }

    public void testContribution_PersistedState_EmptyNullNull() {
        this.testContribution_PersistedState("", null, null);
    }

    public void testContribution_PersistedState_EmptyNullEmpty() {
        this.testContribution_PersistedState("", null, "");
    }

    public void testContribution_PersistedState_EmptyNullString() {
        this.testContribution_PersistedState("", null, "state");
    }

    public void testContribution_PersistedState_EmptyEmptyNull() {
        this.testContribution_PersistedState("", "", null);
    }

    public void testContribution_PersistedState_EmptyEmptyEmpty() {
        this.testContribution_PersistedState("", "", "");
    }

    public void testContribution_PersistedState_EmptyEmptyString() {
        this.testContribution_PersistedState("", "", "state");
    }

    public void testContribution_PersistedState_EmptyStringNull() {
        this.testContribution_PersistedState("", "state", null);
    }

    public void testContribution_PersistedState_EmptyStringEmpty() {
        this.testContribution_PersistedState("", "state", "");
    }

    public void testContribution_PersistedState_EmptyStringString() {
        this.testContribution_PersistedState("", "state", "state");
    }

    public void testContribution_PersistedState_EmptyStringString2() {
        this.testContribution_PersistedState("", "state", "state2");
    }

    public void testContribution_PersistedState_StringNullNull() {
        this.testContribution_PersistedState("state", null, null);
    }

    public void testContribution_PersistedState_StringNullEmpty() {
        this.testContribution_PersistedState("state", null, "");
    }

    public void testContribution_PersistedState_StringNullString() {
        this.testContribution_PersistedState("state", null, "state");
    }

    public void testContribution_PersistedState_StringNullString2() {
        this.testContribution_PersistedState("state", null, "state2");
    }

    public void testContribution_PersistedState_StringEmptyNull() {
        this.testContribution_PersistedState("state", "", null);
    }

    public void testContribution_PersistedState_StringEmptyEmpty() {
        this.testContribution_PersistedState("state", "", "");
    }

    public void testContribution_PersistedState_StringEmptyString() {
        this.testContribution_PersistedState("state", "", "state");
    }

    public void testContribution_PersistedState_StringEmptyString2() {
        this.testContribution_PersistedState("state", "", "state2");
    }

    public void testContribution_PersistedState_StringStringNull() {
        this.testContribution_PersistedState("state", "state", null);
    }

    public void testContribution_PersistedState_StringString2Null() {
        this.testContribution_PersistedState("state", "state2", null);
    }

    public void testContribution_PersistedState_StringStringEmpty() {
        this.testContribution_PersistedState("state", "state", "");
    }

    public void testContribution_PersistedState_StringString2Empty() {
        this.testContribution_PersistedState("state", "state2", "");
    }

    public void testContribution_PersistedState_StringStringString() {
        this.testContribution_PersistedState("state", "state", "state");
    }

    public void testContribution_PersistedState_StringStringString2() {
        this.testContribution_PersistedState("state", "state", "state2");
    }

    public void testContribution_PersistedState_StringString2String() {
        this.testContribution_PersistedState("state", "state2", "state");
    }

    public void testContribution_PersistedState_StringString2String2() {
        this.testContribution_PersistedState("state", "state2", "state2");
    }

    public void testContribution_NewContribution() {
        MApplication application = this.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.getPersistedState().put("key", "value");
        window.getChildren().add(part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerContributionTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        part = (MPart)window.getChildren().get(0);
        ModelReconcilerContributionTest.assertEquals((int)1, (int)part.getPersistedState().size());
        ModelReconcilerContributionTest.assertEquals((String)"value", (String)((String)part.getPersistedState().get("key")));
    }

    public void testContribution_NewPersistedState() {
        MApplication application = this.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.getPersistedState().put("key", "value");
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerContributionTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerContributionTest.assertEquals((Object)part, window.getChildren().get(0));
        ModelReconcilerContributionTest.assertEquals((int)0, (int)part.getPersistedState().size());
        this.applyAll(deltas);
        part = (MPart)window.getChildren().get(0);
        ModelReconcilerContributionTest.assertEquals((int)1, (int)part.getPersistedState().size());
        ModelReconcilerContributionTest.assertEquals((String)"value", (String)((String)part.getPersistedState().get("key")));
    }

    private void testContribution_URI(String applicationURI, String userChange, String newApplicationURI) {
        MApplication application = this.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setContributionURI(applicationURI);
        window.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setContributionURI(userChange);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        part.setContributionURI(newApplicationURI);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerContributionTest.assertEquals((String)newApplicationURI, (String)part.getContributionURI());
        this.applyAll(deltas);
        if (applicationURI == null) {
            if (userChange == null) {
                ModelReconcilerContributionTest.assertEquals((String)newApplicationURI, (String)part.getContributionURI());
            } else {
                ModelReconcilerContributionTest.assertEquals((String)userChange, (String)part.getContributionURI());
            }
        } else if (userChange == null || !applicationURI.equals(userChange)) {
            ModelReconcilerContributionTest.assertEquals((String)userChange, (String)part.getContributionURI());
        } else {
            ModelReconcilerContributionTest.assertEquals((String)newApplicationURI, (String)part.getContributionURI());
        }
    }

    public void testContribution_URI_NullNullNull() {
        this.testContribution_URI(null, null, null);
    }

    public void testContribution_URI_NullNullEmpty() {
        this.testContribution_URI(null, null, "");
    }

    public void testContribution_URI_NullNullString() {
        this.testContribution_URI(null, null, "uri");
    }

    public void testContribution_URI_NullEmptyNull() {
        this.testContribution_URI(null, "", null);
    }

    public void testContribution_URI_NullEmptyEmpty() {
        this.testContribution_URI(null, "", "");
    }

    public void testContribution_URI_NullEmptyString() {
        this.testContribution_URI(null, "", "uri");
    }

    public void testContribution_URI_NullStringNull() {
        this.testContribution_URI(null, "uri", null);
    }

    public void testContribution_URI_NullStringEmpty() {
        this.testContribution_URI(null, "uri", "");
    }

    public void testContribution_URI_NullStringString() {
        this.testContribution_URI(null, "uri", "uri");
    }

    public void testContribution_URI_NullStringString2() {
        this.testContribution_URI(null, "uri", "uri2");
    }

    public void testContribution_URI_EmptyNullNull() {
        this.testContribution_URI("", null, null);
    }

    public void testContribution_URI_EmptyNullEmpty() {
        this.testContribution_URI("", null, "");
    }

    public void testContribution_URI_EmptyNullString() {
        this.testContribution_URI("", null, "uri");
    }

    public void testContribution_URI_EmptyEmptyNull() {
        this.testContribution_URI("", "", null);
    }

    public void testContribution_URI_EmptyEmptyEmpty() {
        this.testContribution_URI("", "", "");
    }

    public void testContribution_URI_EmptyEmptyString() {
        this.testContribution_URI("", "", "uri");
    }

    public void testContribution_URI_EmptyStringNull() {
        this.testContribution_URI("", "uri", null);
    }

    public void testContribution_URI_EmptyStringEmpty() {
        this.testContribution_URI("", "uri", "");
    }

    public void testContribution_URI_EmptyStringString() {
        this.testContribution_URI("", "uri", "uri");
    }

    public void testContribution_URI_EmptyStringString2() {
        this.testContribution_URI("", "uri", "uri2");
    }

    public void testContribution_URI_StringNullNull() {
        this.testContribution_URI("uri", null, null);
    }

    public void testContribution_URI_StringNullEmpty() {
        this.testContribution_URI("uri", null, "");
    }

    public void testContribution_URI_StringNullString() {
        this.testContribution_URI("uri", null, "uri");
    }

    public void testContribution_URI_StringNullString2() {
        this.testContribution_URI("uri", null, "uri2");
    }

    public void testContribution_URI_StringEmptyNull() {
        this.testContribution_URI("uri", "", null);
    }

    public void testContribution_URI_StringEmptyEmpty() {
        this.testContribution_URI("uri", "", "");
    }

    public void testContribution_URI_StringEmptyString() {
        this.testContribution_URI("uri", "", "uri");
    }

    public void testContribution_URI_StringEmptyString2() {
        this.testContribution_URI("uri", "", "uri2");
    }

    public void testContribution_URI_StringStringNull() {
        this.testContribution_URI("uri", "uri", null);
    }

    public void testContribution_URI_StringString2Null() {
        this.testContribution_URI("uri", "uri2", null);
    }

    public void testContribution_URI_StringStringEmpty() {
        this.testContribution_URI("uri", "uri", "");
    }

    public void testContribution_URI_StringString2Empty() {
        this.testContribution_URI("uri", "uri2", "");
    }

    public void testContribution_URI_StringStringString() {
        this.testContribution_URI("uri", "uri", "uri");
    }

    public void testContribution_URI_StringStringString2() {
        this.testContribution_URI("uri", "uri", "uri2");
    }

    public void testContribution_URI_StringString2String() {
        this.testContribution_URI("uri", "uri2", "uri");
    }

    public void testContribution_URI_StringString2String2() {
        this.testContribution_URI("uri", "uri2", "uri2");
    }
}

