/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.palette.root;

import java.util.Collection;
import org.eclipse.e4.xwt.tools.ui.palette.Entry;
import org.eclipse.e4.xwt.tools.ui.palette.page.resources.IPaletteContentProvider;
import org.eclipse.e4.xwt.tools.ui.palette.page.resources.IPaletteLabelProvider;
import org.eclipse.e4.xwt.tools.ui.palette.page.resources.IPaletteResourceProvider;
import org.eclipse.e4.xwt.tools.ui.palette.request.EntryCreationFactory;
import org.eclipse.e4.xwt.tools.ui.palette.root.PaletteDrawerEx;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.jface.resource.ImageDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaletteRootFactory {
    private Collection<IPaletteResourceProvider> resourceProviders;
    private Class<? extends Tool> creationToolClass;
    private Class<? extends Tool> selectionToolClass;

    public PaletteRootFactory(Collection<IPaletteResourceProvider> resourceProviders, Class<? extends Tool> creationToolClass, Class<? extends Tool> selectionToolClass) {
        this.resourceProviders = resourceProviders;
        this.creationToolClass = creationToolClass;
        this.selectionToolClass = selectionToolClass;
    }

    public PaletteRoot createPaletteRoot() {
        PaletteRoot palette = new PaletteRoot();
        if (this.resourceProviders == null) {
            return palette;
        }
        PaletteGroup paletteGroup = new PaletteGroup("Selection Group");
        SelectionToolEntry selectionToolEntry = new SelectionToolEntry();
        paletteGroup.add((PaletteEntry)selectionToolEntry);
        if (this.selectionToolClass != null) {
            selectionToolEntry.setToolClass(this.selectionToolClass);
        }
        MarqueeToolEntry marqueeToolEntry = new MarqueeToolEntry();
        marqueeToolEntry.setToolProperty(AbstractTool.PROPERTY_UNLOAD_WHEN_FINISHED, (Object)true);
        paletteGroup.add((PaletteEntry)marqueeToolEntry);
        palette.add((PaletteEntry)paletteGroup);
        palette.setDefaultEntry((ToolEntry)selectionToolEntry);
        for (IPaletteResourceProvider resourceProvider : this.resourceProviders) {
            Resource resource = resourceProvider.getPaletteResource();
            if (resource == null) continue;
            PaletteContainer rootDrawer = this.createRootDrawer(resource, resourceProvider);
            palette.addAll(rootDrawer.getChildren());
        }
        return palette;
    }

    private PaletteContainer createRootDrawer(Resource resource, IPaletteResourceProvider provider) {
        PaletteDrawer rootDrawer = this.createPaletteDrawer("Root");
        IPaletteContentProvider contentProvider = provider.getContentProvider();
        IPaletteLabelProvider labelProvider = provider.getLabelProvider();
        this.createPaletteStructure(rootDrawer, contentProvider, labelProvider, resource);
        return rootDrawer;
    }

    private void createPaletteStructure(PaletteDrawer parent, IPaletteContentProvider contentProvider, IPaletteLabelProvider labelProvider, Object source) {
        Object[] childNodes;
        Object child;
        if (parent == null || contentProvider == null || labelProvider == null || source == null) {
            return;
        }
        Object[] children = contentProvider.getChildren(source);
        String name = labelProvider.getName(source);
        String description = labelProvider.getToolTip(source);
        ImageDescriptor iconSmall = labelProvider.getSmallIcon(source);
        ImageDescriptor iconLarge = labelProvider.getLargeIcon(source);
        if (name != null && source instanceof Entry) {
            if (children.length == 0) {
                EntryCreationFactory creationFactory = new EntryCreationFactory((Entry)source);
                CombinedTemplateCreationEntry component = new CombinedTemplateCreationEntry(name, description, source, (CreationFactory)creationFactory, iconSmall, iconLarge);
                if (this.creationToolClass != null) {
                    component.setToolClass(this.creationToolClass);
                }
                parent.add((PaletteEntry)component);
            } else {
                PaletteDrawer groupDrawer = this.createPaletteDrawer(name);
                groupDrawer.setSmallIcon(iconSmall);
                groupDrawer.setLargeIcon(iconLarge);
                groupDrawer.setDescription(description);
                parent.add((PaletteEntry)groupDrawer);
                groupDrawer.setParent((PaletteContainer)parent);
                parent = groupDrawer;
            }
        }
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            child = objectArray[n2];
            childNodes = contentProvider.getChildren(child);
            if (childNodes == null || childNodes.length == 0) {
                this.createPaletteStructure(parent, contentProvider, labelProvider, child);
            }
            ++n2;
        }
        objectArray = children;
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            child = objectArray[n2];
            childNodes = contentProvider.getChildren(child);
            if (childNodes != null && childNodes.length != 0) {
                this.createPaletteStructure(parent, contentProvider, labelProvider, child);
            }
            ++n2;
        }
    }

    private PaletteDrawer createPaletteDrawer(String name) {
        PaletteDrawerEx componentsDrawer = new PaletteDrawerEx(name);
        componentsDrawer.setInitialState(1);
        return componentsDrawer;
    }
}

