/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.builder.jface;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class LabeledTableLabelProvider
implements ITableLabelProvider,
ILabelProviderListener {
    private List<ILabelProvider> labelProviders = new ArrayList<ILabelProvider>();
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

    public void clearLabelProviders() {
        this.labelProviders.clear();
    }

    public void addLabelProvider(ILabelProvider labelProvider) {
        this.labelProviders.add(labelProvider);
    }

    public boolean isLabelProperty(Object element, String property) {
        for (IBaseLabelProvider iBaseLabelProvider : this.labelProviders) {
            if (!iBaseLabelProvider.isLabelProperty(element, property)) continue;
            return true;
        }
        return false;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (this.labelProviders.size() > columnIndex) {
            return this.labelProviders.get(columnIndex).getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (this.labelProviders.size() > columnIndex) {
            return this.labelProviders.get(columnIndex).getText(element);
        }
        return null;
    }

    public void dispose() {
        this.labelProviders.clear();
        this.labelProviders = null;
        this.listeners.clear();
        this.listeners = null;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(event);
        }
    }
}

