/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.commands;

import org.eclipse.e4.xwt.tools.ui.designer.commands.AbstractCreateCommand;
import org.eclipse.e4.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.e4.xwt.tools.ui.designer.parts.CoolItemEditPart;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

public class AttachedPropertyCreateCommand
extends AbstractCreateCommand {
    private String attachedProperty;
    private XamlAttribute attachedAttr;

    public AttachedPropertyCreateCommand(EditPart parent, CreateRequest createRequest, String attachedProperty) {
        super(parent, createRequest);
        this.attachedProperty = attachedProperty;
    }

    protected void preExecute(XamlNode newNode, CreateRequest createRequest) {
        this.attachedAttr = this.getParentModel().getAttribute(this.attachedProperty);
    }

    protected Command createCreateCommand(XamlNode parent, XamlNode child) {
        XamlNode newParent = parent;
        XamlNode newChild = child;
        if (this.attachedAttr == null) {
            this.attachedAttr = XamlFactory.eINSTANCE.createAttribute(this.attachedProperty, "http://www.eclipse.org/xwt/presentation");
            newChild = this.attachedAttr;
            if (child instanceof XamlElement) {
                this.attachedAttr.getChildNodes().add((Object)((XamlElement)child));
            }
        } else {
            newParent = this.attachedAttr;
            this.attachedAttr.getChildNodes().clear();
        }
        return new AddNewChildCommand(newParent, newChild);
    }

    public boolean canExecute() {
        if (this.parent instanceof CoolItemEditPart) {
            return this.parent != null && this.getParentModel() != null && this.helper.canCreate(this.parent) && this.attachedProperty != null;
        }
        return this.parent != null && this.getParentModel() != null && this.helper.canCreate(this.parent.getParent()) && this.attachedProperty != null;
    }
}

