/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public abstract class RefreshAdapter
extends AdapterImpl {
    private XamlNode source;
    private boolean isRefreshRequired = true;
    private List<String> notifyAttributeNames = new ArrayList<String>();
    private List<XamlAttribute> notifiedAttributes = new ArrayList<XamlAttribute>();

    public RefreshAdapter(XamlNode source, String affectedAttr) {
        this(source);
        if (affectedAttr != null) {
            this.notifyAttributeNames.add(affectedAttr);
            this.listenAttrs();
        }
    }

    public RefreshAdapter(XamlNode source) {
        Assert.isNotNull((Object)source);
        this.source = source;
        source.eAdapters().add((Object)this);
    }

    public void setRefreshRequired(boolean isRefreshRequired) {
        this.isRefreshRequired = isRefreshRequired;
    }

    private void listenAttrs() {
        for (String attrName : this.notifyAttributeNames) {
            this.listenAttr(this.source.getAttribute(attrName));
        }
    }

    private void listenAttr(XamlAttribute attribute) {
        if (attribute == null || attribute.eAdapters().contains((Object)this)) {
            return;
        }
        attribute.eAdapters().add((Object)this);
        this.notifiedAttributes.add(attribute);
    }

    public void addListenedAttr(String attrName) {
        if (!this.notifyAttributeNames.contains(attrName)) {
            this.notifyAttributeNames.add(attrName);
            this.listenAttrs();
        }
    }

    public final void notifyChanged(Notification msg) {
        if (msg.isTouch()) {
            return;
        }
        if (this.notifyAttributeNames.isEmpty()) {
            return;
        }
        Object notifier = msg.getNotifier();
        if (this.source == notifier) {
            String name;
            Object oldValue = msg.getOldValue();
            Object newValue = msg.getNewValue();
            if (this.notifiedAttributes.contains(oldValue)) {
                if (this.isRefreshRequired) {
                    this.performRefresh(msg);
                }
            } else if (newValue instanceof XamlAttribute && this.notifyAttributeNames.contains(name = ((XamlAttribute)newValue).getName())) {
                this.listenAttr((XamlAttribute)newValue);
                if (this.isRefreshRequired) {
                    this.performRefresh(msg);
                }
            }
        } else if (this.notifiedAttributes.contains(notifier) && this.isRefreshRequired) {
            this.performRefresh(msg);
        }
    }

    public void dispose() {
        this.source.eAdapters().remove((Object)this);
        for (XamlAttribute attr : this.notifiedAttributes) {
            attr.eAdapters().remove((Object)this);
        }
        this.notifiedAttributes.clear();
        this.notifyAttributeNames.clear();
    }

    protected abstract void performRefresh(Notification var1);
}

