/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.parts.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.BindingInfo;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.IObservable;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.Property;

public class DataBindingConnection
extends PolylineConnection {
    private BindingInfo bindingInfo;
    private Label sourceEndpoint;
    private Label targetEndpoint;

    public DataBindingConnection(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
        this.setForegroundColor(ColorConstants.red);
        this.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
        this.setLineJoin(2);
        this.setTargetDecoration(this.createTargetDecoration());
        this.setDisplayEndpoints(true);
    }

    protected void addTargetEndpoint() {
        if (this.bindingInfo == null) {
            return;
        }
        IObservable observeTarget = this.bindingInfo.getTarget();
        if (observeTarget == null) {
            return;
        }
        Property property = this.bindingInfo.getTargetProperty();
        if (property == null) {
            return;
        }
        this.targetEndpoint = new Label(property.toString());
        this.targetEndpoint.setOpaque(false);
        this.targetEndpoint.setBackgroundColor(ColorConstants.buttonLightest);
        this.targetEndpoint.setForegroundColor(ColorConstants.blue);
        this.targetEndpoint.setBorder((Border)new LineBorder());
        ConnectionEndpointLocator locator = new ConnectionEndpointLocator((Connection)this, true);
        locator.setUDistance(2);
        locator.setVDistance(3);
        this.add((IFigure)this.targetEndpoint, locator);
    }

    protected void addSourceEndpoint() {
        if (this.bindingInfo == null) {
            return;
        }
        IObservable model = this.bindingInfo.getModel();
        if (model == null) {
            return;
        }
        Property property = this.bindingInfo.getModelProperty();
        if (property == null) {
            return;
        }
        this.sourceEndpoint = new Label(property.toString());
        this.sourceEndpoint.setOpaque(false);
        this.sourceEndpoint.setBackgroundColor(ColorConstants.buttonLightest);
        this.sourceEndpoint.setForegroundColor(ColorConstants.blue);
        this.sourceEndpoint.setBorder((Border)new LineBorder());
        ConnectionEndpointLocator locator = new ConnectionEndpointLocator((Connection)this, false);
        locator.setUDistance(2);
        locator.setVDistance(-3);
        this.add((IFigure)this.sourceEndpoint, locator);
    }

    protected RotatableDecoration createTargetDecoration() {
        return new PolygonDecoration();
    }

    protected RotatableDecoration createSourceDecoration() {
        PolylineDecoration sourceDec = new PolylineDecoration();
        PointList pl = new PointList();
        pl.addPoint(-2, 1);
        pl.addPoint(0, 1);
        pl.addPoint(0, -1);
        pl.addPoint(-2, -1);
        sourceDec.setTemplate(pl);
        sourceDec.setScale(7.0, 3.0);
        return sourceDec;
    }

    public void setDisplayEndpoints(boolean display) {
        if (display) {
            this.addSourceEndpoint();
            this.addTargetEndpoint();
        } else {
            if (this.sourceEndpoint != null && this == this.sourceEndpoint.getParent()) {
                this.remove((IFigure)this.sourceEndpoint);
                this.sourceEndpoint = null;
            }
            if (this.targetEndpoint != null && this == this.targetEndpoint.getParent()) {
                this.remove((IFigure)this.targetEndpoint);
                this.targetEndpoint = null;
            }
        }
    }
}

