/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.snippet019;

import java.net.URL;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.tests.snippet019.Bean;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class TreeViewerWithListFactory {
    private IObservableValue clipboard = new WritableValue(XWT.getRealm());

    public static void main(String[] args) {
        URL url = TreeViewerWithListFactory.class.getResource(String.valueOf(TreeViewerWithListFactory.class.getSimpleName()) + ".xwt");
        try {
            XWT.open((URL)url, (Object)new Bean("input"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addRoot(Object sender, Event e) {
        Bean bean = (Bean)XWT.getDataContext((Object)e.widget);
        IObservableList observableList = XWT.findObservableList((Object)e.widget, (Object)bean, (String)"list");
        Bean root = TreeViewerWithListFactory.createBean("root");
        observableList.add((Object)root);
        TreeViewer beanViewer = (TreeViewer)XWT.findElementByName((Object)e.widget, (String)"TreeViewer");
        beanViewer.setSelection((ISelection)new StructuredSelection((Object)root));
        Text beanText = (Text)XWT.findElementByName((Object)e.widget, (String)"nameText");
        beanText.selectAll();
        beanText.setFocus();
    }

    public static Bean createBean(String name) {
        return new Bean(name);
    }

    public void addChild(Object sender, Event e) {
        TreeViewer beanViewer = (TreeViewer)XWT.findElementByName((Object)e.widget, (String)"TreeViewer");
        IStructuredSelection structuredSelection = (IStructuredSelection)beanViewer.getSelection();
        Bean bean = (Bean)structuredSelection.getFirstElement();
        IObservableList observableList = XWT.findObservableList((Object)e.widget, (Object)bean, (String)"list");
        Bean root = TreeViewerWithListFactory.createBean("root");
        observableList.add((Object)root);
        beanViewer.setSelection((ISelection)new StructuredSelection((Object)root));
        Text beanText = (Text)XWT.findElementByName((Object)e.widget, (String)"nameText");
        beanText.selectAll();
        beanText.setFocus();
    }

    public void remove(Object sender, Event e) {
        TreeViewer beanViewer = (TreeViewer)XWT.findElementByName((Object)e.widget, (String)"TreeViewer");
        IStructuredSelection structuredSelection = (IStructuredSelection)beanViewer.getSelection();
        Bean bean = (Bean)structuredSelection.getFirstElement();
        TreeItem selectedItem = beanViewer.getTree().getSelection()[0];
        TreeItem parentItem = selectedItem.getParentItem();
        Bean parent = parentItem == null ? (Bean)beanViewer.getInput() : (Bean)parentItem.getData();
        IObservableList observableList = XWT.findObservableList((Object)e.widget, (Object)parent, (String)"list");
        observableList.remove((Object)bean);
    }

    public void copy(Object sender, Event e) {
        TreeViewer beanViewer = (TreeViewer)XWT.findElementByName((Object)e.widget, (String)"TreeViewer");
        IStructuredSelection structuredSelection = (IStructuredSelection)beanViewer.getSelection();
        Bean bean = (Bean)structuredSelection.getFirstElement();
        this.clipboard.setValue((Object)bean);
    }

    public void paste(Object sender, Event e) {
        TreeViewer beanViewer = (TreeViewer)XWT.findElementByName((Object)e.widget, (String)"TreeViewer");
        IStructuredSelection structuredSelection = (IStructuredSelection)beanViewer.getSelection();
        Bean bean = (Bean)structuredSelection.getFirstElement();
        IObservableList observableList = XWT.findObservableList((Object)e.widget, (Object)bean, (String)"list");
        Bean child = (Bean)this.clipboard.getValue();
        observableList.add((Object)child);
        beanViewer.setSelection((ISelection)new StructuredSelection((Object)child));
        Text beanText = (Text)XWT.findElementByName((Object)e.widget, (String)"nameText");
        beanText.selectAll();
        beanText.setFocus();
    }

    public void refresh(Object sender, Event e) {
        TreeViewer beanViewer = (TreeViewer)XWT.findElementByName((Object)e.widget, (String)"TreeViewer");
        beanViewer.refresh();
    }
}

