/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.animation.internal;

import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;
import org.eclipse.e4.xwt.metadata.ModelUtils;
import org.pushingpixels.trident.TimelinePropertyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathPropertyAccessor<T>
implements TimelinePropertyBuilder.PropertyAccessor<T> {
    private String path;
    private String[] segments;
    private Object cacheObject;
    private Object cacheHost;
    private IProperty property;

    public PathPropertyAccessor(String path) {
        this.path = path;
        this.segments = path.split("\\.");
    }

    public T get(Object object, String fieldName) {
        this.checkCache(object);
        try {
            return (T)this.property.getValue(this.cacheObject);
        }
        catch (Exception exception) {
            throw new XWTException("Value access fails: property \"" + this.segments[this.segments.length - 1] + "\" of the path \"" + this.path + "\" is not found in the class \"" + object.getClass().getName() + "\".");
        }
    }

    public void set(Object object, String fieldName, T value) {
        this.checkCache(object);
        try {
            this.property.setValue(this.cacheObject, value);
        }
        catch (Exception exception) {
            throw new XWTException("Value access fails: property \"" + this.segments[this.segments.length - 1] + "\" of the path \"" + this.path + "\" is not found in the class \"" + object.getClass().getName() + "\".");
        }
    }

    protected void checkCache(Object object) {
        if (object == this.cacheHost && this.cacheObject != null) {
            return;
        }
        Object target = object;
        IProperty currentProperty = null;
        IMetaclass metaclass = XWT.getMetaclass(target);
        int i = 0;
        while (i < this.segments.length) {
            String segment = ModelUtils.normalizePropertyName(this.segments[i]);
            currentProperty = metaclass.findProperty(segment);
            if (currentProperty == null) {
                this.cacheObject = null;
                throw new XWTException("Property \"" + segment + "\" of the path \"" + this.path + "\" is not found in the class \"" + object.getClass().getName() + "\".");
            }
            try {
                this.cacheObject = target;
                target = currentProperty.getValue(target);
                metaclass = XWT.getMetaclass(target);
            }
            catch (Exception exception) {
                this.cacheObject = null;
                throw new XWTException("Value access fails: property \"" + segment + "\" of the path \"" + this.path + "\" is not found in the class \"" + object.getClass().getName() + "\".");
            }
            ++i;
        }
        this.property = currentProperty;
        this.cacheHost = object;
    }
}

