/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.Designer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class SourceSelectionProvider
implements ISelectionProvider {
    private Designer designer;
    private StructuredTextEditor textEditor;
    private List<ISelectionChangedListener> listeners;
    private IStructuredSelection fSelection;

    public SourceSelectionProvider(Designer designer, StructuredTextEditor textEditor) {
        this.designer = designer;
        this.textEditor = textEditor;
        ISelectionProvider selectionProvider = textEditor.getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    TextSelection textSelection;
                    ISelection selection = event.getSelection();
                    if (selection instanceof TextSelection && (textSelection = (TextSelection)selection).getOffset() == 0) {
                        return;
                    }
                    SourceSelectionProvider.this.handleTextSelection(event);
                }
            });
        }
    }

    private List getSelectedNodes() {
        ISelection selection = this.textEditor.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return null;
    }

    protected void handleTextSelection(SelectionChangedEvent event) {
        List selectedNodes = this.getSelectedNodes();
        if (selectedNodes == null || selectedNodes.isEmpty()) {
            return;
        }
        this.fSelection = null;
        if (selectedNodes != null && !selectedNodes.isEmpty()) {
            ArrayList editParts = new ArrayList();
            for (Object object : selectedNodes) {
                EObject model = this.designer.getModelBuilder().getModel(object);
                if (model != null) continue;
            }
            if (!editParts.isEmpty()) {
                this.fSelection = new StructuredSelection(editParts);
            }
        }
        if (this.fSelection == null) {
            return;
        }
        final SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.fSelection);
        int i = 0;
        while (i < this.listeners.size()) {
            final ISelectionChangedListener l = this.listeners.get(i);
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(newEvent);
                }
            });
            ++i;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ISelectionChangedListener>();
        }
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.fSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
        Object[] array;
        StructuredTextViewer textViewer = this.textEditor.getTextViewer();
        StyledText styledText = textViewer.getTextWidget();
        if (Display.getDefault().getFocusControl() == styledText) {
            return;
        }
        ArrayList<IDOMNode> newSelection = new ArrayList<IDOMNode>();
        Object[] objectArray = array = ((IStructuredSelection)selection).toArray();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            EditPart editPart;
            Object model;
            Object object = objectArray[n2];
            if (object instanceof EditPart && (model = (editPart = (EditPart)object).getModel()) instanceof EObject) {
                EObject node = (EObject)model;
                IDOMNode textNode = this.designer.getModelBuilder().getTextNode(node);
                if (textNode != null) {
                    newSelection.add(textNode);
                }
            }
            ++n2;
        }
        List selectedNodes = this.getSelectedNodes();
        if (selectedNodes != null && selectedNodes.containsAll(newSelection) && newSelection.containsAll(selectedNodes)) {
            return;
        }
        String content = styledText.getText();
        int startOffset = -1;
        int endOffset = 0;
        for (Object e : newSelection) {
            String segment;
            IDOMNode textNode = (IDOMNode)e;
            int nodeStartOffset = textNode.getStartOffset();
            int nodeEndOffset = textNode.getEndOffset();
            if (startOffset == -1) {
                startOffset = nodeStartOffset;
                endOffset = nodeEndOffset;
                continue;
            }
            if (nodeStartOffset > startOffset) {
                if (nodeStartOffset < endOffset) continue;
                segment = content.substring(endOffset, nodeStartOffset).trim();
                if (segment.length() == 0) {
                    endOffset = nodeEndOffset;
                    continue;
                }
                startOffset = 0;
                endOffset = 0;
                break;
            }
            if (nodeEndOffset > startOffset) continue;
            segment = content.substring(nodeEndOffset, startOffset).trim();
            if (segment.length() == 0) {
                startOffset = nodeStartOffset;
                continue;
            }
            startOffset = 0;
            endOffset = 0;
            break;
        }
        if (startOffset == -1) {
            startOffset = 0;
        }
        int n3 = endOffset - startOffset;
        textViewer.setRangeIndication(startOffset, n3, false);
        this.textEditor.selectAndReveal(startOffset, n3);
    }
}

