/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerToolBarContributionTest
extends ModelReconcilerTest {
    private void testToolBarContribution_PositionInParent(String before, String after) {
        MApplication application = this.createApplication();
        MToolBarContribution contribution = MenuFactoryImpl.eINSTANCE.createToolBarContribution();
        application.getToolBarContributions().add(contribution);
        contribution.setPositionInParent(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        contribution.setPositionInParent(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        contribution = (MToolBarContribution)application.getToolBarContributions().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerToolBarContributionTest.assertEquals((int)1, (int)application.getToolBarContributions().size());
        ModelReconcilerToolBarContributionTest.assertEquals((Object)contribution, application.getToolBarContributions().get(0));
        ModelReconcilerToolBarContributionTest.assertEquals((String)before, (String)contribution.getPositionInParent());
        this.applyAll(deltas);
        ModelReconcilerToolBarContributionTest.assertEquals((int)1, (int)application.getToolBarContributions().size());
        ModelReconcilerToolBarContributionTest.assertEquals((Object)contribution, application.getToolBarContributions().get(0));
        ModelReconcilerToolBarContributionTest.assertEquals((String)after, (String)contribution.getPositionInParent());
    }

    public void testToolBarContribution_PositionInParent_NullNull() {
        this.testToolBarContribution_PositionInParent(null, null);
    }

    public void testToolBarContribution_PositionInParent_NullEmpty() {
        this.testToolBarContribution_PositionInParent(null, "");
    }

    public void testToolBarContribution_PositionInParent_NullString() {
        this.testToolBarContribution_PositionInParent(null, "id");
    }

    public void testToolBarContribution_PositionInParent_EmptyNull() {
        this.testToolBarContribution_PositionInParent("", null);
    }

    public void testToolBarContribution_PositionInParent_EmptyEmpty() {
        this.testToolBarContribution_PositionInParent("", "");
    }

    public void testToolBarContribution_PositionInParent_EmptyString() {
        this.testToolBarContribution_PositionInParent("", "id");
    }

    public void testToolBarContribution_PositionInParent_StringNull() {
        this.testToolBarContribution_PositionInParent("id", null);
    }

    public void testToolBarContribution_PositionInParent_StringEmpty() {
        this.testToolBarContribution_PositionInParent("id", "");
    }

    public void testToolBarContribution_PositionInParent_StringStringUnchanged() {
        this.testToolBarContribution_PositionInParent("id", "id");
    }

    public void testToolBarContribution_PositionInParent_StringStringChanged() {
        this.testToolBarContribution_PositionInParent("id", "id2");
    }

    private void testToolBarContribution_ParentId(String before, String after) {
        MApplication application = this.createApplication();
        MToolBarContribution contribution = MenuFactoryImpl.eINSTANCE.createToolBarContribution();
        application.getToolBarContributions().add(contribution);
        contribution.setParentId(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        contribution.setParentId(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        contribution = (MToolBarContribution)application.getToolBarContributions().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerToolBarContributionTest.assertEquals((int)1, (int)application.getToolBarContributions().size());
        ModelReconcilerToolBarContributionTest.assertEquals((Object)contribution, application.getToolBarContributions().get(0));
        ModelReconcilerToolBarContributionTest.assertEquals((String)before, (String)contribution.getParentId());
        this.applyAll(deltas);
        ModelReconcilerToolBarContributionTest.assertEquals((int)1, (int)application.getToolBarContributions().size());
        ModelReconcilerToolBarContributionTest.assertEquals((Object)contribution, application.getToolBarContributions().get(0));
        ModelReconcilerToolBarContributionTest.assertEquals((String)after, (String)contribution.getParentId());
    }

    public void testToolBarContribution_ParentId_NullNull() {
        this.testToolBarContribution_ParentId(null, null);
    }

    public void testToolBarContribution_ParentId_NullEmpty() {
        this.testToolBarContribution_ParentId(null, "");
    }

    public void testToolBarContribution_ParentId_NullString() {
        this.testToolBarContribution_ParentId(null, "id");
    }

    public void testToolBarContribution_ParentId_EmptyNull() {
        this.testToolBarContribution_ParentId("", null);
    }

    public void testToolBarContribution_ParentId_EmptyEmpty() {
        this.testToolBarContribution_ParentId("", "");
    }

    public void testToolBarContribution_ParentId_EmptyString() {
        this.testToolBarContribution_ParentId("", "id");
    }

    public void testToolBarContribution_ParentId_StringNull() {
        this.testToolBarContribution_ParentId("id", null);
    }

    public void testToolBarContribution_ParentId_StringEmpty() {
        this.testToolBarContribution_ParentId("id", "");
    }

    public void testToolBarContribution_ParentId_StringStringUnchanged() {
        this.testToolBarContribution_ParentId("id", "id");
    }

    public void testToolBarContribution_ParentId_StringStringChanged() {
        this.testToolBarContribution_ParentId("id", "id2");
    }
}

