/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.deeplink.api;

import org.eclipse.e4.core.functionalprog.optionmonad.None;
import org.eclipse.e4.core.functionalprog.optionmonad.Option;
import org.eclipse.e4.core.functionalprog.optionmonad.Some;

public class URLPathInfoParser {
    public final String handlerType;
    public final String handlerId;
    public final Option<String> action;

    public URLPathInfoParser(String urlPathInfo) {
        if (urlPathInfo == null || "/".equals(urlPathInfo)) {
            throw new IllegalArgumentException("Empty URL path: nothing to do");
        }
        String[] urlParts = urlPathInfo.split("/+");
        if (urlParts.length < 3) {
            throw new IllegalArgumentException("Need both of: '/handlerType/handlerInstanceId' in URL but got: " + urlPathInfo);
        }
        this.handlerType = urlParts[1];
        this.handlerId = urlParts[2];
        this.action = urlParts.length > 3 ? Some.some((Object)urlParts[3]) : None.none();
    }

    public String toString() {
        return String.valueOf(this.handlerType) + "/" + this.handlerId + (this.action.hasValue() ? "/" + (String)this.action.get() : "");
    }
}

