/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.xaml.tools;

import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;

public class XamlCreateTools {
    public static XamlAttribute addAttribute(XamlNode parent, String name, String namespace, String value) {
        if (parent == null || name == null || namespace == null) {
            throw new NullPointerException();
        }
        XamlAttribute attribute = parent.getAttribute(name, namespace);
        boolean isNew = false;
        if (attribute == null) {
            attribute = XamlFactory.eINSTANCE.createXamlAttribute();
            attribute.setName(name);
            attribute.setNamespace(namespace);
            isNew = true;
        }
        if (value != null) {
            attribute.setValue(value);
        }
        if (isNew) {
            parent.getAttributes().add((Object)attribute);
        }
        return attribute;
    }

    public static XamlAttribute addAttribute(XamlNode parent, String name, String namespace) {
        return XamlCreateTools.addAttribute(parent, name, namespace, null);
    }

    public static XamlAttribute addComplexAttribute(XamlElement parent, String name, String namespace, String childName, String childNamespace) {
        return XamlCreateTools.addComplexAttribute(parent, name, namespace, childName, childNamespace, false);
    }

    public static XamlAttribute addComplexAttribute(XamlElement parent, String name, String namespace, String childName, String childNamespace, boolean allowMutilChild) {
        if (parent == null || name == null || namespace == null || childName == null || childNamespace == null) {
            throw new NullPointerException();
        }
        XamlAttribute attribute = parent.getAttribute(name, namespace);
        if (attribute == null) {
            attribute = XamlCreateTools.createAttribute(name, namespace);
            XamlElement child = XamlCreateTools.createElement(childName, childNamespace);
            attribute.getChildNodes().add((Object)child);
            parent.getAttributes().add((Object)attribute);
        } else if (attribute.getChild(childName, childNamespace) == null) {
            XamlElement child = XamlCreateTools.createElement(childName, childNamespace);
            if (!allowMutilChild) {
                attribute.getChildNodes().clear();
            }
            attribute.getChildNodes().add((Object)child);
        }
        return attribute;
    }

    public static XamlAttribute createAttribute(String name, String namespace) {
        if (name == null || namespace == null) {
            throw new NullPointerException();
        }
        XamlAttribute attribute = XamlFactory.eINSTANCE.createXamlAttribute();
        attribute.setName(name);
        attribute.setNamespace(namespace);
        return attribute;
    }

    public static XamlElement createElement(String name, String namespace) {
        if (name == null || namespace == null) {
            throw new NullPointerException();
        }
        XamlElement element = XamlFactory.eINSTANCE.createXamlElement();
        element.setName(name);
        element.setNamespace(namespace);
        return element;
    }

    private XamlCreateTools() {
    }
}

