/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.services.impl;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.e4.tools.services.IMessageFactoryService;
import org.eclipse.e4.tools.services.Message;
import org.eclipse.e4.tools.services.impl.PropertiesBundleTranslationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFactoryServiceImpl
implements IMessageFactoryService {
    private Map<Object, Reference<Object>> SOFT_CACHE = Collections.synchronizedMap(new HashMap());
    private Map<Object, Reference<Object>> WEAK_CACHE = Collections.synchronizedMap(new HashMap());
    private int CLEANUPCOUNT = 0;

    @Override
    public <M> M createInstance(final String locale, final Class<M> messages) throws InstantiationException, IllegalAccessException {
        String key = String.valueOf(messages.getName()) + "_" + locale;
        final Message annotation = messages.getAnnotation(Message.class);
        Map<Object, Reference<Object>> cache = null;
        Message.ReferenceType type = Message.ReferenceType.NONE;
        if (++this.CLEANUPCOUNT > 1000) {
            Iterator<Map.Entry<Object, Reference<Object>>> it = this.WEAK_CACHE.entrySet().iterator();
            while (it.hasNext()) {
                if (it.next().getValue().get() != null) continue;
                it.remove();
            }
            it = this.SOFT_CACHE.entrySet().iterator();
            while (it.hasNext()) {
                if (it.next().getValue().get() != null) continue;
                it.remove();
            }
            this.CLEANUPCOUNT = 0;
        }
        if (annotation == null || annotation.referenceType() == Message.ReferenceType.SOFT) {
            cache = this.SOFT_CACHE;
            type = Message.ReferenceType.SOFT;
        } else if (annotation.referenceType() == Message.ReferenceType.WEAK) {
            cache = this.WEAK_CACHE;
            type = Message.ReferenceType.WEAK;
        }
        if (cache != null && cache.containsKey(key)) {
            Reference<Object> ref = cache.get(key);
            Object o = ref.get();
            if (o != null) {
                return (M)o;
            }
            cache.remove(key);
        }
        Object instance = System.getSecurityManager() == null ? MessageFactoryServiceImpl.doCreateInstance(locale, messages, annotation) : AccessController.doPrivileged(new PrivilegedAction<M>(){

            @Override
            public M run() {
                try {
                    return MessageFactoryServiceImpl.doCreateInstance(locale, messages, annotation);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        if (cache != null) {
            if (type == Message.ReferenceType.SOFT) {
                cache.put(key, new SoftReference<M>(instance));
            } else if (type == Message.ReferenceType.WEAK) {
                cache.put(key, new WeakReference<M>(instance));
            }
        }
        return instance;
    }

    private static <M> M doCreateInstance(String locale, Class<M> messages, Message annotation) throws InstantiationException, IllegalAccessException {
        String basename = messages.getName().replace('.', '/');
        PropertiesBundleTranslationProvider provider = new PropertiesBundleTranslationProvider(messages.getClassLoader(), basename);
        M instance = messages.newInstance();
        Field[] fields = messages.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (!fields[i].isAccessible()) {
                fields[i].setAccessible(true);
            }
            fields[i].set(instance, provider.translate(locale, fields[i].getName()));
            ++i;
        }
        return instance;
    }
}

