/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.core.internal.favorites;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.platform.discovery.core.internal.favorites.IPersistenceUtil;
import org.eclipse.platform.discovery.runtime.api.persistence.DestinationItemPair;
import org.eclipse.platform.discovery.runtime.internal.persistence.IMementoContentManager;
import org.eclipse.platform.discovery.runtime.internal.persistence.MementoContentManagerException;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class SearchFavoritesPersistenceUtil
implements IPersistenceUtil {
    private final IPersistenceContext<DestinationItemPair> persistenceContext;

    public SearchFavoritesPersistenceUtil(IPersistenceContext<DestinationItemPair> persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    @Override
    public void addItems(Set<DestinationItemPair> itemsToAdd, ILongOperationRunner opRunner) throws WorkbenchException, IOException, MementoContentManagerException {
        Set<DestinationItemPair> originalItems = this.loadItems(opRunner);
        originalItems.addAll(itemsToAdd);
        IMemento tempContentStorage = this.provideStorageMemento();
        this.persistenceContext.getContentManager().saveContent(tempContentStorage, originalItems, opRunner);
        this.saveMemento(tempContentStorage);
    }

    @Override
    public void deleteItems(Set<Object> itemsToDelete, ILongOperationRunner opRunner) throws WorkbenchException, IOException, MementoContentManagerException {
        Set<DestinationItemPair> loadedPairs = this.loadItems(opRunner);
        HashSet<DestinationItemPair> pairsToDelete = new HashSet<DestinationItemPair>();
        for (DestinationItemPair pair : loadedPairs) {
            if (!itemsToDelete.contains(pair.getItem())) continue;
            pairsToDelete.add(pair);
        }
        loadedPairs.removeAll(pairsToDelete);
        IMemento mementoStorage = this.createStorageMemento();
        this.persistenceContext.getContentManager().saveContent(mementoStorage, loadedPairs, opRunner);
        this.saveMemento(mementoStorage);
    }

    protected void saveMemento(IMemento memento) throws IOException {
        assert (memento instanceof XMLMemento);
        ((XMLMemento)memento).save((Writer)new FileWriter(this.persistenceContext.getFile()));
    }

    @Override
    public Set<DestinationItemPair> loadItems(ILongOperationRunner opRunner) throws WorkbenchException, IOException, MementoContentManagerException {
        IMemento tempContentStorage = this.provideStorageMemento();
        return new HashSet<DestinationItemPair>(this.persistenceContext.getContentManager().loadContent(tempContentStorage, opRunner));
    }

    protected IMemento provideStorageMemento() throws IOException, WorkbenchException {
        if (this.persistenceContext.getFile().exists()) {
            return XMLMemento.createReadRoot((Reader)new FileReader(this.persistenceContext.getFile()));
        }
        return this.createStorageMemento();
    }

    protected IMemento createStorageMemento() {
        return XMLMemento.createWriteRoot((String)"memento-root");
    }

    public static interface IPersistenceContext<T> {
        public IMementoContentManager<T> getContentManager() throws MementoContentManagerException;

        public File getFile();
    }
}

