/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.internal.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.IMetaclassFactory;
import org.eclipse.e4.xwt.IXWTLoader;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.internal.core.MetaclassService;
import org.eclipse.e4.xwt.internal.utils.ClassLoaderUtil;
import org.eclipse.e4.xwt.javabean.metadata.Metaclass;
import org.eclipse.e4.xwt.metadata.IMetaclass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaclassManager {
    protected Map<String, IMetaclass> nameRegister = new HashMap<String, IMetaclass>();
    protected Collection<Class<?>> classRegister = new HashSet();
    protected MetaclassManager parent;
    protected MetaclassService service;
    private IXWTLoader xwtLoader;

    public MetaclassManager(MetaclassService service, MetaclassManager parent, IXWTLoader xwtLoader) {
        this.parent = parent;
        this.service = service;
        this.xwtLoader = xwtLoader;
    }

    public Collection<IMetaclass> getAllMetaclasses() {
        return this.nameRegister.values();
    }

    public void register(IMetaclass metaclass) {
        Class<?> type = metaclass.getType();
        if (this.classRegister.contains(type)) {
            return;
        }
        String key = type.getSimpleName();
        this.nameRegister.put(key, metaclass);
        this.classRegister.add(type);
    }

    public IMetaclass register(Class<?> javaClass) {
        return this.register(javaClass, null);
    }

    public IMetaclass register(Class<?> javaClass, IMetaclass superMetaclass) {
        IMetaclass metaclass = this.getMetaclass(javaClass);
        if (metaclass != null) {
            return metaclass;
        }
        if (superMetaclass == null) {
            Class<?> superclass = javaClass.getSuperclass();
            if (superclass != null && superclass != Object.class) {
                this.register(superclass, null);
            }
            superMetaclass = this.getMetaclass(superclass);
        }
        IMetaclass thisMetaclass = this.createMetaclass(javaClass, superMetaclass);
        this.register(thisMetaclass);
        return thisMetaclass;
    }

    protected IMetaclass createMetaclass(Class<?> javaClass, IMetaclass superMetaclass) {
        IMetaclassFactory factory;
        if (this.service != null && (factory = this.service.findFactory(javaClass)) != null) {
            return factory.create(javaClass, superMetaclass, this.xwtLoader);
        }
        boolean lazyLoading = false;
        return new Metaclass(javaClass, superMetaclass, lazyLoading, this.xwtLoader);
    }

    public IMetaclass getMetaclass(ILoadingContext context, String name, String namespace) {
        Class<?> type;
        String className;
        int index;
        String packageName;
        IMetaclass metaclass = this.nameRegister.get(name);
        if (metaclass != null) {
            if (namespace == null || namespace.equals("http://www.eclipse.org/xwt/presentation")) {
                return metaclass;
            }
            if (namespace != null && namespace.startsWith("clr-namespace:")) {
                packageName = namespace.substring("clr-namespace:".length());
                index = packageName.indexOf(61);
                if (index != -1) {
                    packageName = packageName.substring(0, index);
                }
                String string = className = packageName.length() == 0 ? name : String.valueOf(packageName) + "." + name;
                if (metaclass.getType().getName().equals(className)) {
                    return metaclass;
                }
            }
        }
        if (namespace == null || !namespace.startsWith("clr-namespace:")) {
            return null;
        }
        packageName = namespace.substring("clr-namespace:".length());
        index = packageName.indexOf(61);
        if (index != -1) {
            packageName = packageName.substring(0, index);
        }
        if ((type = ClassLoaderUtil.loadClass(context, className = packageName.length() == 0 ? name : String.valueOf(packageName) + "." + name)) == null) {
            throw new XWTException("Cannot load " + className);
        }
        metaclass = this.register(type, null);
        this.nameRegister.remove(type.getSimpleName());
        return metaclass;
    }

    public IMetaclass getMetaclass(Object object) {
        if (object instanceof Class) {
            return this.getMetaclass((Class)object);
        }
        if (object instanceof String) {
            return this.getMetaclass((String)object);
        }
        Class<?> type = object.getClass();
        return this.getMetaclass(type);
    }

    public IMetaclass getMetaclass(Class<?> type) {
        IMetaclass metaclass;
        if (this.classRegister.contains(type) && (metaclass = this.nameRegister.get(type.getSimpleName())) != null && metaclass.getType() == type) {
            return metaclass;
        }
        if (this.parent != null && (metaclass = this.parent.getMetaclass(type)) != null) {
            return metaclass;
        }
        return null;
    }
}

