/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;

public class ContextFunctionDynamicsTest
extends TestCase {
    private static final String SELECTION = "selection";

    public void testChangeICF() throws Exception {
        IEclipseContext context1 = EclipseContextFactory.create((String)"context1");
        IEclipseContext context2 = context1.createChild("context2");
        context1.set(SELECTION, (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                return "func1";
            }
        });
        InjectTarget target = new InjectTarget();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)context2);
        ContextFunctionDynamicsTest.assertEquals((Object)"func1", (Object)target.input);
        context1.set(SELECTION, (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                return "func2";
            }
        });
        ContextFunctionDynamicsTest.assertEquals((Object)"func2", (Object)target.input);
    }

    public void testOverrideICF() throws Exception {
        IEclipseContext context1 = EclipseContextFactory.create((String)"context1");
        IEclipseContext context2 = context1.createChild("context2");
        IEclipseContext context3 = context2.createChild("context3");
        context1.set(SELECTION, (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                return "func1";
            }
        });
        InjectTarget target = new InjectTarget();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)context3);
        ContextFunctionDynamicsTest.assertEquals((Object)"func1", (Object)target.input);
        Object o = new Object();
        context2.set(SELECTION, o);
        ContextFunctionDynamicsTest.assertEquals((Object)o, (Object)target.input);
    }

    public void testLongChain() throws Exception {
        IEclipseContext context1 = EclipseContextFactory.create((String)"context1");
        IEclipseContext context2 = context1.createChild("context2");
        IEclipseContext context3 = context2.createChild("context3");
        IEclipseContext context4 = context3.createChild("context4");
        context1.set(SELECTION, (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                return "func1";
            }
        });
        InjectTarget target = new InjectTarget();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)context4);
        ContextFunctionDynamicsTest.assertEquals((Object)"func1", (Object)target.input);
        context2.set(SELECTION, (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                return "func2";
            }
        });
        ContextFunctionDynamicsTest.assertEquals((Object)"func2", (Object)target.input);
        context2.remove(SELECTION);
        ContextFunctionDynamicsTest.assertEquals((Object)"func1", (Object)target.input);
        context3.set(SELECTION, (Object)"abc");
        ContextFunctionDynamicsTest.assertEquals((Object)"abc", (Object)target.input);
        context3.remove(SELECTION);
        ContextFunctionDynamicsTest.assertEquals((Object)"func1", (Object)target.input);
    }

    public void testBug315109() throws Exception {
        IEclipseContext appContext = EclipseContextFactory.create();
        IEclipseContext windowContext = appContext.createChild();
        IEclipseContext partContext = windowContext.createChild();
        partContext.activateBranch();
        appContext.set(SELECTION, (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                IEclipseContext parent = context.getParent();
                while (parent != null) {
                    context = parent;
                    parent = context.getParent();
                }
                return context.getActiveLeaf().get("out.selection");
            }
        });
        InjectTarget target = new InjectTarget();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)partContext);
        ContextFunctionDynamicsTest.assertNull((String)"No selection has been set, should be null", (Object)target.input);
        Object o = new Object();
        windowContext.set(SELECTION, o);
        ContextFunctionDynamicsTest.assertEquals((String)"A selection was set into the window, should have been injected into the part", (Object)o, (Object)target.input);
    }

    static class InjectTarget {
        Object input;

        InjectTarget() {
        }

        @Inject
        @Optional
        void setInput(@Named(value="selection") Object input) {
            this.input = input;
        }
    }
}

