/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class DisposeClassLinkTest
extends TestCase {
    public void testMake() throws Exception {
        IEclipseContext context = EclipseContextFactory.create();
        Test test = (Test)ContextInjectionFactory.make(Test.class, (IEclipseContext)context);
        DisposeClassLinkTest.assertEquals((int)0, (int)test.getCount());
        context.dispose();
        DisposeClassLinkTest.assertEquals((int)1, (int)test.getCount());
    }

    public void testDisposeParent() throws Exception {
        IEclipseContext parentContext = EclipseContextFactory.create();
        IEclipseContext context = parentContext.createChild();
        Test test = (Test)ContextInjectionFactory.make(Test.class, (IEclipseContext)context);
        DisposeClassLinkTest.assertEquals((int)0, (int)test.getCount());
        context.dispose();
        DisposeClassLinkTest.assertEquals((int)1, (int)test.getCount());
        parentContext.dispose();
        DisposeClassLinkTest.assertEquals((int)1, (int)test.getCount());
    }

    public void testInject() throws Exception {
        IEclipseContext parentContext = EclipseContextFactory.create();
        IEclipseContext context = parentContext.createChild();
        Test test = new Test();
        ContextInjectionFactory.inject((Object)test, (IEclipseContext)context);
        DisposeClassLinkTest.assertEquals((int)0, (int)test.getCount());
        context.dispose();
        DisposeClassLinkTest.assertEquals((int)1, (int)test.getCount());
    }

    public void testDisposeParentFirst() throws Exception {
        IEclipseContext parentContext = EclipseContextFactory.create();
        IEclipseContext context = parentContext.createChild();
        Test test = new Test();
        ContextInjectionFactory.inject((Object)test, (IEclipseContext)context);
        DisposeClassLinkTest.assertEquals((int)0, (int)test.getCount());
        context.dispose();
        DisposeClassLinkTest.assertEquals((int)1, (int)test.getCount());
        parentContext.dispose();
        DisposeClassLinkTest.assertEquals((int)1, (int)test.getCount());
    }

    public void testInjectedWithContext() throws Exception {
        IEclipseContext context = EclipseContextFactory.create();
        InjectionObject obj = (InjectionObject)ContextInjectionFactory.make(InjectionObject.class, (IEclipseContext)context);
        DisposeClassLinkTest.assertEquals((String)"The object has been injected with the context", (Object)context, (Object)obj.context);
        DisposeClassLinkTest.assertEquals((String)"@PostConstruct should have been called once", (int)1, (int)obj.postConstruct);
        DisposeClassLinkTest.assertEquals((String)"@PreDestroy should not have been called", (int)0, (int)obj.preDestroy);
        context.dispose();
        DisposeClassLinkTest.assertNotNull((Object)obj.context);
        DisposeClassLinkTest.assertEquals((String)"@PostConstruct should only have been called once", (int)1, (int)obj.postConstruct);
        DisposeClassLinkTest.assertEquals((String)"@PreDestroy should have been called during uninjection", (int)1, (int)obj.preDestroy);
    }

    public static class InjectionObject {
        @Inject
        IEclipseContext context;
        int postConstruct = 0;
        int preDestroy = 0;

        @PostConstruct
        void construct() {
            ++this.postConstruct;
        }

        @PreDestroy
        void destroy() {
            ++this.preDestroy;
        }
    }

    public static class Test {
        private int count = 0;

        public int getCount() {
            return this.count;
        }

        @PreDestroy
        void preDestroy() {
            ++this.count;
        }
    }
}

