/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.result.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.ITooltipProvider;
import org.eclipse.platform.discovery.ui.internal.tooltip.FormTextBuilder;
import org.eclipse.swt.graphics.Image;

public class GenericResultLabelProvider
extends CellLabelProvider
implements ILabelProvider {
    private final Set<ILabelProvider> labelProviders = new HashSet<ILabelProvider>();
    private final Set<ITooltipProvider> tooltipProviders = new HashSet<ITooltipProvider>();

    public GenericResultLabelProvider(Set<IGenericViewCustomization> viewCustomizations) {
        for (IGenericViewCustomization customization : viewCustomizations) {
            if (customization.getLabelProvider() != null) {
                this.labelProviders.add(customization.getLabelProvider());
            }
            if (customization.getTooltipProvider() == null) continue;
            this.tooltipProviders.add(customization.getTooltipProvider());
        }
    }

    public Image getImage(Object element) {
        for (ILabelProvider lProvider : this.labelProviders) {
            Image img = lProvider.getImage(element);
            if (img == null) continue;
            return img;
        }
        return null;
    }

    public String getText(Object element) {
        for (ILabelProvider lProvider : this.labelProviders) {
            String text = lProvider.getText(element);
            if (text == null) continue;
            return text;
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void update(ViewerCell cell) {
        cell.setText(this.getText(cell.getElement()));
        cell.setImage(this.getImage(cell.getElement()));
    }

    public String getToolTipText(Object element) {
        FormTextBuilder textB = new FormTextBuilder();
        for (ITooltipProvider ttProvider : this.tooltipProviders) {
            ttProvider.createTooltipContent(textB, element);
        }
        return textB.getText();
    }
}

