/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.server.bespin;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.e4.server.bespin.AuthenticationServlet;
import org.eclipse.e4.server.bespin.BundleEntryHttpContext;
import org.eclipse.e4.server.bespin.CVSServlet;
import org.eclipse.e4.server.bespin.EditingServlet;
import org.eclipse.e4.server.bespin.FilesServlet;
import org.eclipse.e4.server.bespin.MarkersServlet;
import org.eclipse.e4.server.bespin.ProjectsServlet;
import org.eclipse.e4.server.bespin.SettingsServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private ServiceTracker httpServiceTracker;
    protected static volatile BundleContext bundleContext;
    static /* synthetic */ Class class$0;

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        this.httpServiceTracker = new HttpServiceTracker(this, context);
        this.httpServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.httpServiceTracker.close();
        this.httpServiceTracker = null;
        bundleContext = null;
    }

    private class HttpServiceTracker
    extends ServiceTracker {
        final /* synthetic */ Activator this$0;

        public HttpServiceTracker(Activator activator, BundleContext context) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.http.HttpService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            super(context, clazz.getName(), null);
            this.this$0 = activator;
        }

        public Object addingService(ServiceReference reference) {
            HttpService httpService = (HttpService)super.addingService(reference);
            if (httpService == null) {
                return null;
            }
            BundleEntryHttpContext httpContext = new BundleEntryHttpContext(this.context.getBundle());
            Bundle bespinBundle = this.getBespinBundle();
            BundleEntryHttpContext bespinHttpContext = new BundleEntryHttpContext(bespinBundle);
            try {
                httpService.registerResources("/", "/frontend", (HttpContext)bespinHttpContext);
                httpService.registerResources("/eclipse/commands", "/commands", (HttpContext)httpContext);
                httpService.registerServlet("/register", (Servlet)new AuthenticationServlet(), null, (HttpContext)httpContext);
                httpService.registerServlet("/edit", (Servlet)new EditingServlet(), null, (HttpContext)httpContext);
                httpService.registerServlet("/file", (Servlet)new FilesServlet(), null, (HttpContext)httpContext);
                httpService.registerServlet("/markers", (Servlet)new MarkersServlet(), null, (HttpContext)httpContext);
                httpService.registerServlet("/cvs", (Servlet)new CVSServlet(), null, (HttpContext)httpContext);
                httpService.registerServlet("/project", (Servlet)new ProjectsServlet(), null, (HttpContext)httpContext);
                httpService.registerServlet("/settings", (Servlet)new SettingsServlet(), null, (HttpContext)httpContext);
            }
            catch (NamespaceException e) {
                e.printStackTrace();
            }
            catch (ServletException e) {
                e.printStackTrace();
            }
            return httpService;
        }

        private Bundle getBespinBundle() {
            Bundle[] bundles = this.context.getBundles();
            int i = 0;
            while (i < bundles.length) {
                if (bundles[i].getSymbolicName().equals("bespin")) {
                    return bundles[i];
                }
                ++i;
            }
            throw new IllegalStateException("Couldn't find the 'bespin' bundle.");
        }

        public void removedService(ServiceReference reference, Object service) {
            HttpService httpService = (HttpService)service;
            httpService.unregister("/");
            httpService.unregister("/register");
            httpService.unregister("/edit");
            httpService.unregister("/file");
            httpService.unregister("/markers");
            httpService.unregister("/cvs");
            httpService.unregister("/project");
            httpService.unregister("/settings");
            super.removedService(reference, service);
        }
    }
}

