/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.server.bespin;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProjectSetCapability;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;

public class CVS {
    public void checkOut(Object projectNameOrNames, String repo, Object moduleNameOrNames, String tagName) {
        String[] projectNames = this.asStringArray(projectNameOrNames);
        String[] moduleNames = this.asStringArray(moduleNameOrNames);
        new ProgressRunnable(projectNames, repo, moduleNames, tagName).run((IProgressMonitor)new NullProgressMonitor());
    }

    private String[] asStringArray(Object stringOrStringArray) {
        String[] result;
        if (stringOrStringArray instanceof String) {
            result = new String[]{(String)stringOrStringArray};
        } else {
            Object[] strings = (Object[])stringOrStringArray;
            result = new String[strings.length];
            System.arraycopy(strings, 0, result, 0, strings.length);
        }
        return result;
    }

    private static final class ProgressRunnable {
        private final String[] moduleNames;
        private final String[] projectNames;
        private final String tagName;
        private final String repo;

        private ProgressRunnable(String[] projectNames, String repo, String[] moduleNames, String tag) {
            this.moduleNames = moduleNames;
            this.projectNames = projectNames;
            this.tagName = tag;
            this.repo = repo;
        }

        public void run(IProgressMonitor monitor) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] projects = new IProject[this.projectNames.length];
            int i = 0;
            while (i < this.projectNames.length) {
                projects[i] = root.getProject(this.projectNames[i]);
                ++i;
            }
            CVSTag tag = this.tagName == null || this.tagName.equals("HEAD") ? new CVSTag() : new CVSTag(this.tagName, 2);
            try {
                ResourcesPlugin.getPlugin();
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)new WorkspaceRunnable(projects, this.repo, this.moduleNames, tag), (ISchedulingRule)root, 0, monitor);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class WorkspaceRunnable
    implements IWorkspaceRunnable {
        private final CVSTag tag;
        private final IProject[] projects;
        private String repo;
        private String[] moduleNames;

        private WorkspaceRunnable(IProject[] projects, String repo, String[] moduleNames, CVSTag tag) {
            this.projects = projects;
            this.repo = repo;
            this.moduleNames = moduleNames;
            this.tag = tag;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                int i = 0;
                while (i < this.projects.length) {
                    CVSProjectSetCapability.checkout((ICVSRepositoryLocation)CVSRepositoryLocation.fromString((String)this.repo), (IProject)this.projects[i], (String)this.moduleNames[i], (CVSTag)this.tag, (IProgressMonitor)monitor);
                    ++i;
                }
            }
            catch (CVSException e) {
                throw new RuntimeException(e);
            }
            catch (TeamException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

