/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public abstract class TmPartStyle {
    protected Composite treeParent;
    protected List<Composite> tmComposites = new ArrayList<Composite>();
    protected List<Object> tmCompositeKeys = new ArrayList<Object>();

    public Composite getTreeParent() {
        return this.treeParent;
    }

    protected void addTmComposite(Object key, Composite composite) {
        this.tmCompositeKeys.add(key);
        this.tmComposites.add(composite);
    }

    public abstract Composite addTmComposite(Object var1);

    public Composite getTmComposite(Object key) {
        return this.tmComposites.get(this.tmCompositeKeys.indexOf(key));
    }

    protected void disposeTmComposite(Object key) {
        this.tmComposites.get(this.tmCompositeKeys.indexOf(key)).dispose();
        this.tmCompositeKeys.remove(key);
    }

    public void createPageContainer(Composite parent) {
        if (this.treeParent == null) {
            this.createTreeParent(parent);
        }
    }

    protected Composite createTmComposite(Composite parent) {
        return new Composite(parent, 512);
    }

    abstract void createTreeParent(Composite var1);

    public static class SashStyle
    extends TmPartStyle {
        private SashForm sashForm;

        public void createTreeParent(Composite parent) {
            this.sashForm = new SashForm(parent, 256);
            this.treeParent = new Composite((Composite)this.sashForm, 0);
        }

        public Composite addTmComposite(Object key) {
            Composite composite = this.createTmComposite((Composite)this.sashForm);
            this.sashForm.layout();
            this.addTmComposite(key, composite);
            return composite;
        }
    }

    public static class SashTabFolderStyle
    extends TmPartStyle {
        private TabFolder tabFolder;

        public void createTreeParent(Composite parent) {
            SashForm sashForm = new SashForm(parent, 256);
            this.treeParent = new Composite((Composite)sashForm, 0);
            this.tabFolder = new TabFolder((Composite)sashForm, 1024);
        }

        public Composite addTmComposite(Object key) {
            TabItem tmTab = new TabItem(this.tabFolder, 0);
            tmTab.setText(key.toString());
            Composite composite = this.createTmComposite((Composite)this.tabFolder);
            tmTab.setControl((Control)composite);
            return composite;
        }
    }

    public static class TabFolderStyle
    extends TmPartStyle {
        private String treeTabTitle;
        private TabFolder tabFolder;

        public TabFolderStyle(String treeTabTitle) {
            this.treeTabTitle = treeTabTitle;
        }

        public TabFolderStyle() {
            this("Toolkit model");
        }

        public void createTreeParent(Composite parent) {
            this.tabFolder = new TabFolder(parent, 1024);
            TabItem treeTab = new TabItem(this.tabFolder, 0);
            treeTab.setText(this.treeTabTitle);
            this.treeParent = new Composite((Composite)this.tabFolder, 0);
            treeTab.setControl((Control)this.treeParent);
        }

        public Composite addTmComposite(Object key) {
            TabItem tmTab = new TabItem(this.tabFolder, 0);
            tmTab.setText(key.toString());
            Composite composite = this.createTmComposite((Composite)this.tabFolder);
            tmTab.setControl((Control)composite);
            return composite;
        }
    }
}

