/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.virtual;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.ComponentLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MBindingTableContainer;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VBindingTableEditor
extends AbstractComponentEditor {
    private Composite composite;
    private EMFDataBindingContext context;
    private TableViewer bindingViewer;
    private List<Action> actions = new ArrayList<Action>();

    @Inject
    public VBindingTableEditor() {
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.VBindingTableEditor_AddBindingTable, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.BindingTable")){

            public void run() {
                VBindingTableEditor.this.handleAdd();
            }
        });
    }

    @Override
    public Image getImage(Object element, Display display) {
        return null;
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.VBindingTableEditor_Label;
    }

    @Override
    public String getDetailLabel(Object element) {
        return null;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.VBindingTableEditor_Description;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            this.composite = this.createForm(parent, this.context, this.getMaster());
        }
        VirtualEntry o = (VirtualEntry)object;
        this.bindingViewer.setInput((Object)o.getList());
        this.getMaster().setValue(o.getOriginalParent());
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue master) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        Label l = new Label(parent, 0);
        l.setText(this.Messages.VBindingTableEditor_BindingTables);
        l.setLayoutData((Object)new GridData(2));
        this.bindingViewer = new TableViewer(parent);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        this.bindingViewer.setContentProvider((IContentProvider)cp);
        GridData gd = new GridData(1808);
        this.bindingViewer.getControl().setLayoutData((Object)gd);
        this.bindingViewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider(this.getEditor(), this.Messages));
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayoutData((Object)new GridData(4, 3, false, false));
        GridLayout gl = new GridLayout();
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        buttonComp.setLayout((Layout)gl);
        Button b = new Button(buttonComp, 0x800008);
        b.setText(this.Messages.ModelTooling_Common_Up);
        b.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.arrow_up"));
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection s;
                if (!VBindingTableEditor.this.bindingViewer.getSelection().isEmpty() && (s = (IStructuredSelection)VBindingTableEditor.this.bindingViewer.getSelection()).size() == 1) {
                    Command cmd;
                    Object obj = s.getFirstElement();
                    MBindingTableContainer container = (MBindingTableContainer)VBindingTableEditor.this.getMaster().getValue();
                    int idx = container.getBindingTables().indexOf(obj) - 1;
                    if (idx >= 0 && (cmd = MoveCommand.create((EditingDomain)VBindingTableEditor.this.getEditingDomain(), (Object)VBindingTableEditor.this.getMaster().getValue(), (Object)CommandsPackageImpl.Literals.BINDING_TABLE_CONTAINER__BINDING_TABLES, (Object)obj, (int)idx)).canExecute()) {
                        VBindingTableEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                        VBindingTableEditor.this.bindingViewer.setSelection((ISelection)new StructuredSelection(obj));
                    }
                }
            }
        });
        b = new Button(buttonComp, 0x800008);
        b.setText(this.Messages.ModelTooling_Common_Down);
        b.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.arrow_down"));
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection s;
                if (!VBindingTableEditor.this.bindingViewer.getSelection().isEmpty() && (s = (IStructuredSelection)VBindingTableEditor.this.bindingViewer.getSelection()).size() == 1) {
                    Command cmd;
                    Object obj = s.getFirstElement();
                    MBindingTableContainer container = (MBindingTableContainer)VBindingTableEditor.this.getMaster().getValue();
                    int idx = container.getBindingTables().indexOf(obj) + 1;
                    if (idx < container.getBindingTables().size() && (cmd = MoveCommand.create((EditingDomain)VBindingTableEditor.this.getEditingDomain(), (Object)VBindingTableEditor.this.getMaster().getValue(), (Object)CommandsPackageImpl.Literals.BINDING_TABLE_CONTAINER__BINDING_TABLES, (Object)obj, (int)idx)).canExecute()) {
                        VBindingTableEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                        VBindingTableEditor.this.bindingViewer.setSelection((ISelection)new StructuredSelection(obj));
                    }
                }
            }
        });
        b = new Button(buttonComp, 0x800008);
        b.setText(this.Messages.ModelTooling_Common_AddEllipsis);
        b.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.table_add"));
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VBindingTableEditor.this.handleAdd();
            }
        });
        b = new Button(buttonComp, 0x800008);
        b.setText(this.Messages.ModelTooling_Common_Remove);
        b.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.table_delete"));
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!VBindingTableEditor.this.bindingViewer.getSelection().isEmpty()) {
                    List commands = ((IStructuredSelection)VBindingTableEditor.this.bindingViewer.getSelection()).toList();
                    Command cmd = RemoveCommand.create((EditingDomain)VBindingTableEditor.this.getEditingDomain(), (Object)VBindingTableEditor.this.getMaster().getValue(), (Object)CommandsPackageImpl.Literals.BINDING_TABLE_CONTAINER__BINDING_TABLES, (Collection)commands);
                    if (cmd.canExecute()) {
                        VBindingTableEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                    }
                }
            }
        });
        folder.setSelection(0);
        return folder;
    }

    protected void handleAdd() {
        MBindingTable command = MCommandsFactory.INSTANCE.createBindingTable();
        this.setElementId(command);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)CommandsPackageImpl.Literals.BINDING_TABLE_CONTAINER__BINDING_TABLES, (Object)command);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(command);
        }
    }

    @Override
    public IObservableList getChildList(Object element) {
        return null;
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }
}

