/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor.dnd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.ui.editor.XWTEditor;
import org.eclipse.e4.xwt.ui.editor.dnd.DnDAdapterImpl;
import org.eclipse.e4.xwt.utils.PathHelper;
import org.eclipse.e4.xwt.vex.VEXContext;
import org.eclipse.e4.xwt.vex.dom.DomHelper;
import org.eclipse.e4.xwt.vex.toolpalette.ContextType;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ImageDnDAdapter
extends DnDAdapterImpl {
    private static List<String> supportedImageExts = new ArrayList<String>();
    private static List<String> supportedImageAttrs = new ArrayList<String>();
    private IFile image;
    private IFile editorInput;
    private IDOMNode acceptAttr;

    static {
        supportedImageExts.add("png");
        supportedImageExts.add("gif");
        supportedImageExts.add("bmp");
        supportedImageAttrs.add("image");
        supportedImageAttrs.add("backgroundImage");
    }

    public ImageDnDAdapter(XWTEditor editor) {
        super(editor);
        this.editorInput = ((FileEditorInput)editor.getEditorInput()).getFile();
    }

    protected Template createTemplate(Object selection) {
        String pattern = this.computePath();
        if (this.acceptAttr == null) {
            pattern = "image=\"" + pattern + "\"";
        }
        return new Template("image", "", this.getContextType().getName(), pattern, true);
    }

    private String computePath() {
        if (this.editorInput != null) {
            return PathHelper.getRelativePath((String)this.editorInput.getLocation().toString(), (String)this.image.getLocation().toString());
        }
        return this.image.getLocation().toString();
    }

    protected boolean isAccept(Object selection) {
        if (selection instanceof IFile) {
            String ext = ((IFile)selection).getFileExtension();
            boolean contains = supportedImageExts.contains(ext);
            if (contains) {
                this.image = (IFile)selection;
            }
            return contains;
        }
        return false;
    }

    public void drop(DropTargetEvent event) {
        Object selection = this.getSelection();
        if (!this.isAccept()) {
            return;
        }
        Template template = this.createTemplate(selection);
        if (template == null) {
            return;
        }
        String nodeValue = this.acceptAttr == null ? "" : this.acceptAttr.getNodeValue();
        this.drop(template, this.getDropCaretOffset(), nodeValue == null ? 0 : nodeValue.length());
    }

    public void dragOver(DropTargetEvent event) {
        NamedNodeMap attributes;
        if (!this.isAccept()) {
            return;
        }
        IDOMNode node = (IDOMNode)this.getCurrentNode(event);
        int cursor = this.getCursor(event);
        VEXContext context = this.getEditor().getContext();
        int position = context.findDropPosition((Node)node, this.getScope(), this.getContextType(), cursor);
        if (position >= 0 && (attributes = node.getAttributes()) != null) {
            this.acceptAttr = this.getAttr(node, cursor);
            StyledText styledText = this.getEditor().getTextWidget();
            if (this.acceptAttr == null && this.hasImageFeature(node)) {
                this.setDropCaretOffset(cursor);
                this.refreshCaret(styledText, this.getDropCaretOffset());
                return;
            }
            if (this.acceptAttr != null && supportedImageAttrs.contains(this.acceptAttr.getNodeName())) {
                this.setDropCaretOffset(this.getInsertion(this.acceptAttr, cursor));
                this.refreshCaret(styledText, this.getDropCaretOffset());
                return;
            }
        }
        event.detail = 0;
    }

    private boolean hasImageFeature(IDOMNode node) {
        boolean hasImageAttr = this.getImageAttr(node) == null;
        String nodeName = node.getNodeName();
        IMetaclass metaclass = XWT.getMetaclass((String)nodeName, (String)DomHelper.lookupNamespaceURI((Node)node));
        if (metaclass != null) {
            hasImageAttr &= metaclass.findProperty("image") != null;
        }
        return hasImageAttr;
    }

    private int getInsertion(IDOMNode acceptAttr, int cursor) {
        if (acceptAttr == null) {
            return cursor;
        }
        return acceptAttr.getStartOffset() + acceptAttr.getNodeName().length() + 2;
    }

    private IDOMNode getAttr(IDOMNode node, int cursor) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        int i = 0;
        while (i < attributes.getLength()) {
            IDOMNode attr = (IDOMNode)attributes.item(i);
            int startOffset = attr.getStartOffset();
            int endOffset = attr.getEndOffset();
            if (cursor >= startOffset && cursor < endOffset) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    private IDOMNode getImageAttr(IDOMNode node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        int i = 0;
        while (i < attributes.getLength()) {
            IDOMNode attr = (IDOMNode)attributes.item(i);
            if (supportedImageAttrs.contains(attr.getNodeName())) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    public ContextType getContextType() {
        return ContextType.XML_ATTRIBUTE_VALUE;
    }

    public String getScope() {
        return null;
    }
}

