/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal.persistence.xp;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.platform.discovery.runtime.api.persistence.IMementoLoadProvider;
import org.eclipse.platform.discovery.runtime.internal.persistence.model.descriptions.IMementoLoadProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.persistence.xp.IMementoLoadProviderExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;

public class MementoLoadProvidersExtensionParser
extends AbstractExtensionPointParser
implements IMementoLoadProviderExtensionParser {
    private static final String XP_ID = "org.eclipse.platform.discovery.integration.persistence.mementoloadprovider";
    private static final String XP_ELEMENT_NAME = "provider";
    private static final String CLASS_ATTR = "class";

    public MementoLoadProvidersExtensionParser() {
        super(Platform.getExtensionRegistry(), XP_ID, XP_ELEMENT_NAME);
    }

    @Override
    public Set<IMementoLoadProviderDescription> readContributions() {
        HashSet<IMementoLoadProviderDescription> result = new HashSet<IMementoLoadProviderDescription>();
        for (IConfigurationElement element : this.getConfigurationElements()) {
            result.add(this.createMementoLoadProvider(element));
        }
        return result;
    }

    private IMementoLoadProviderDescription createMementoLoadProvider(final IConfigurationElement element) {
        return new IMementoLoadProviderDescription(){

            @Override
            public IMementoLoadProvider createInstance() {
                try {
                    return (IMementoLoadProvider)element.createExecutableExtension(MementoLoadProvidersExtensionParser.CLASS_ATTR);
                }
                catch (CoreException e) {
                    throw new IllegalStateException("Load provider could not be instantiated", e);
                }
            }
        };
    }
}

