/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import org.eclipse.e4.xwt.IConstants;
import org.eclipse.e4.xwt.internal.xml.Element;
import org.eclipse.e4.xwt.internal.xml.ElementManager;
import org.xml.sax.SAXException;

public class DocumentObject
extends Observable
implements Cloneable {
    private String id;
    private String name;
    private String namespace;
    private String content;
    private List<DocumentObject> children;
    protected DocumentObject parent;

    public DocumentObject(String namespace, String name) {
        assert (namespace != null);
        assert (name != null);
        this.children = new LinkedList<DocumentObject>();
        this.setNamespace(namespace);
        this.setName(name);
    }

    public void addChild(DocumentObject child) {
        assert (child != null);
        if (this.children.add(child)) {
            DocumentObject oParent = child.getParent();
            if (oParent != null) {
                oParent.delChild(child);
            }
            child.setParent(this);
        }
    }

    public DocumentObject[] getChildren() {
        return this.children.toArray(IConstants.EMPTY_DOCOBJ_ARRAY);
    }

    public String getContent() {
        return this.content;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void include(ElementManager elementManager, InputStream input) throws IOException {
        try {
            elementManager.load(input, this);
        }
        catch (SAXException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public void include(ElementManager elementManager, String path) throws IOException {
        InputStream input = elementManager.getDocumentRoot().openStream(path);
        if (input != null) {
            this.include(elementManager, input);
        }
        input.close();
    }

    public void setContent(String text) {
        this.content = text;
    }

    public Object clone() throws CloneNotSupportedException {
        DocumentObject docobj = (DocumentObject)super.clone();
        docobj.id = null;
        DocumentObject[] documentObjectArray = this.getChildren();
        int n = documentObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentObject child = documentObjectArray[n2];
            DocumentObject nChild = (DocumentObject)child.clone();
            docobj.addChild(nChild);
            ++n2;
        }
        return docobj;
    }

    protected void setId(String id) {
        if (this.id != null) {
            throw new IllegalStateException("Element id is already defined");
        }
        assert (id != null);
        this.id = id;
    }

    protected void setNamespace(String namespace) {
        assert (namespace != null) : "Element namespace is null";
        assert (this.namespace != null) : "Element namepsace is defined";
        this.namespace = namespace;
    }

    protected void setName(String name) {
        assert (name != null) : "Element name is null";
        assert (this.name != null) : "Element name is defined";
        this.name = name;
    }

    protected void delChild(DocumentObject child) {
        DocumentObject parent;
        assert (child != null);
        if (child instanceof Element && (parent = ((Element)child).getParent()) != null && parent.equals(this)) {
            this.children.remove(child);
            ((Element)child).setParent(null);
        }
    }

    public DocumentObject getParent() {
        return this.parent;
    }

    public void setParent(DocumentObject parent) {
        this.parent = parent;
    }
}

