/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.cacheservice;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.core.internal.resources.semantic.cacheservice.CacheService;
import org.eclipse.core.internal.resources.semantic.cacheservice.ITemporaryContentHandle;
import org.eclipse.core.internal.resources.semantic.cacheservice.Messages;
import org.eclipse.core.resources.semantic.spi.ICacheUpdateCallback;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class CachingOutputStream
extends OutputStream {
    private final CacheService cacheService;
    private final ITemporaryContentHandle fileHandle;
    private final ICacheUpdateCallback callback;
    private final boolean appendMode;
    private boolean closed;

    protected CachingOutputStream(CacheService service, ITemporaryContentHandle tempHandle, boolean append, ICacheUpdateCallback callback) {
        this.cacheService = service;
        this.fileHandle = tempHandle;
        this.appendMode = append;
        this.callback = callback;
        this.closed = false;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        InputStream stream = null;
        try {
            try {
                long timestamp = System.currentTimeMillis();
                this.closed = true;
                try {
                    stream = this.fileHandle.closeAndGetContents();
                    long appendPosition = this.fileHandle.getAppendPosition();
                    this.skipUntilAppendPosition(stream, appendPosition);
                    this.callback.beforeCacheUpdate(stream, timestamp, this.appendMode);
                }
                finally {
                    Util.safeClose(stream);
                    stream = null;
                }
                this.cacheService.addFromTempHandle(this.fileHandle);
                IPath path = this.fileHandle.getKey();
                stream = this.cacheService.getContent(path);
                long appendPosition = this.fileHandle.getAppendPosition();
                this.skipUntilAppendPosition(stream, appendPosition);
                this.callback.cacheUpdated(stream, timestamp, this.appendMode);
            }
            catch (CoreException e) {
                throw new IOException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Util.safeClose(stream);
            throw throwable;
        }
        Util.safeClose(stream);
    }

    private void skipUntilAppendPosition(InputStream stream, long appendPosition) throws IOException {
        long skipped = 0L;
        if (appendPosition > 0L) {
            skipped = stream.skip(appendPosition);
        }
        if (skipped < appendPosition) {
            throw new IOException(MessageFormat.format(Messages.CachingOutputStream_CouldNotSkip_XMSG, appendPosition, skipped));
        }
    }

    public void flush() throws IOException {
        this.fileHandle.flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.fileHandle.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.fileHandle.write(b);
    }

    public void write(int b) throws IOException {
        this.fileHandle.write(b);
    }
}

