/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.ui.XWTUIPlugin;
import org.eclipse.e4.xwt.ui.editor.XWTCodeSynchronizer;
import org.eclipse.e4.xwt.ui.editor.XWTDropTargetListener;
import org.eclipse.e4.xwt.ui.editor.XWTFileChecker;
import org.eclipse.e4.xwt.ui.editor.XWTUIContext;
import org.eclipse.e4.xwt.ui.editor.dnd.ImageDnDAdapter;
import org.eclipse.e4.xwt.ui.editor.dnd.PaletteDnDAdapter;
import org.eclipse.e4.xwt.ui.editor.dnd.UserDefinedDnDAdapter;
import org.eclipse.e4.xwt.ui.editor.render.XWTRender;
import org.eclipse.e4.xwt.ui.editor.treeviewer.XWTTableTreeViewer;
import org.eclipse.e4.xwt.ui.utils.DisplayUtil;
import org.eclipse.e4.xwt.ui.utils.ImageManager;
import org.eclipse.e4.xwt.ui.utils.ProjectContext;
import org.eclipse.e4.xwt.ui.views.XWTView;
import org.eclipse.e4.xwt.vex.VEXCodeSynchronizer;
import org.eclipse.e4.xwt.vex.VEXContext;
import org.eclipse.e4.xwt.vex.VEXEditor;
import org.eclipse.e4.xwt.vex.VEXFileChecker;
import org.eclipse.e4.xwt.vex.VEXFileFormator;
import org.eclipse.e4.xwt.vex.VEXRenderer;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;

public class XWTEditor
extends VEXEditor {
    private CompilationUnitEditor javaEditor;
    private IFile javaFile;
    private String className;
    private DropTargetListener dropTargetAdapter;
    private ToolItem previewTool;
    private ToolItem generateTool;
    private long modificationStamp;
    private IElementChangedListener elementChangedListener = new IElementChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            if (XWTEditor.this.getFileChecker() != null) {
                long timeStamp = XWTEditor.this.javaFile.getModificationStamp();
                if (XWTEditor.this.modificationStamp == timeStamp) {
                    XWTEditor.this.getFileChecker().doCheck(XWTEditor.this.render.getHostClassName());
                } else {
                    XWTEditor.this.modificationStamp = timeStamp;
                }
            }
        }
    };

    public XWTEditor() {
        super((VEXContext)new XWTUIContext());
    }

    public CompilationUnitEditor getJavaEditor() {
        return this.javaEditor;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        XWTUIPlugin.getDefault().openXWTPerspective();
    }

    protected IDesignViewer createDesignPage() {
        XWTTableTreeViewer tableTreeViewer = new XWTTableTreeViewer(this.getContainer());
        XMLUIPlugin.getInstance().getWorkbench().getHelpSystem().setHelp(tableTreeViewer.getControl(), "org.eclipse.wst.xml.ui.xmlm3000");
        return tableTreeViewer;
    }

    protected VEXRenderer createRender(Canvas container) {
        return new XWTRender(container, this.changeListener);
    }

    protected void createToolBar(CTabFolder tabFolder) {
        tabFolder.setTabPosition(128);
        tabFolder.setSimple(false);
        ToolBar toolBar = new ToolBar((Composite)tabFolder, 8519744);
        this.previewTool = new ToolItem(toolBar, 8);
        this.previewTool.setImage(ImageManager.get((String)ImageManager.IMG_PREVIEW));
        this.previewTool.setToolTipText("Preview");
        this.previewTool.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                XWTEditor.this.handlePreview();
            }

            public void widgetSelected(SelectionEvent e) {
                XWTEditor.this.handlePreview();
            }
        });
        this.generateTool = new ToolItem(toolBar, 8);
        this.generateTool.setImage(JavaPluginImages.get((String)"org.eclipse.jdt.ui.class_obj.gif"));
        this.generateTool.setToolTipText("Generate Java codes");
        this.generateTool.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                XWTEditor.this.generateCLRCodeAction();
            }

            public void widgetSelected(SelectionEvent e) {
                XWTEditor.this.generateCLRCodeAction();
            }
        });
        this.generateTool.setEnabled(false);
        tabFolder.setTopRight((Control)toolBar);
        tabFolder.setTabHeight(Math.max(toolBar.computeSize((int)-1, (int)-1).y, tabFolder.getTabHeight()));
    }

    void handlePreview() {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
        if (!javaProject.exists()) {
            return;
        }
        try {
            XWT.setLoadingContext((ILoadingContext)ProjectContext.getContext((IJavaProject)javaProject));
            DisplayUtil.open((IFile)file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setJavaEditor(String fullyQualifiedName) {
        IJavaProject javaProject = this.getJavaProject();
        this.removeElementChangedListener(javaProject);
        try {
            if (fullyQualifiedName == null) {
                return;
            }
            IType type = javaProject.findType(fullyQualifiedName);
            if (type == null || !type.exists()) {
                return;
            }
            this.javaFile = (IFile)type.getResource();
            FileEditorInput editorInput = new FileEditorInput(this.javaFile);
            if (this.javaEditor == null) {
                this.javaEditor = new CompilationUnitEditor();
                int javaPageIndex = this.addPage((IEditorPart)this.javaEditor, (IEditorInput)editorInput);
                this.setPageText(javaPageIndex, "Java");
                this.setPageImage(javaPageIndex, JavaPluginImages.get((String)"org.eclipse.jdt.ui.class_obj.gif"));
            } else {
                this.javaEditor.setInput((IEditorInput)editorInput);
            }
            this.className = fullyQualifiedName;
            if (this.generateTool != null) {
                this.generateTool.setEnabled(true);
            }
            this.addElementChangedListener(javaProject);
            XWTCodeSynchronizer codeSynchronizer = (XWTCodeSynchronizer)this.getCodeSynchronizer();
            codeSynchronizer.setType(type);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    protected IJavaProject getJavaProject() {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
        if (!javaProject.exists()) {
            return null;
        }
        return javaProject;
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.javaEditor != null) {
            this.javaEditor.doSave(monitor);
        }
    }

    protected boolean handleInputChanged(IDocument newInput) {
        String value = newInput.get();
        if (newInput == null) {
            return false;
        }
        boolean handling = super.handleInputChanged(newInput);
        if (handling) {
            String className = this.render.getHostClassName();
            if (this.className == null || !this.className.equals(className)) {
                this.setJavaEditor(className);
            }
        }
        this.refreshXWTView(value);
        return handling;
    }

    private void refreshXWTView(String value) {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            XWTUIPlugin.checkStartup();
            try {
                XWTView view = (XWTView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.e4.xwt.ui.views.XWTView");
                if (view != null) {
                    view.setContentWithException(value, file);
                }
            }
            catch (Exception exception) {}
        }
    }

    protected VEXFileChecker createFileChecker() {
        return new XWTFileChecker(this.getTextEditor());
    }

    protected VEXCodeSynchronizer createCodeSynchronizer() {
        IJavaProject javaProject;
        block4: {
            try {
                javaProject = this.getJavaProject();
                if (javaProject != null && this.className != null) break block4;
                return null;
            }
            catch (JavaModelException javaModelException) {}
        }
        IType findType = javaProject.findType(this.className);
        if (findType != null) {
            return new XWTCodeSynchronizer(this, findType);
        }
        return null;
    }

    public void addElementChangedListener(IJavaProject javaProject) {
        int eventMask = 5;
        JavaModelManager.getDeltaState().addElementChangedListener(this.elementChangedListener, eventMask);
    }

    public void removeElementChangedListener(IJavaProject javaProject) {
        JavaModelManager.getDeltaState().removeElementChangedListener(this.elementChangedListener);
    }

    public void initializeDND(VEXEditor editor) {
        if (this.dropTargetAdapter == null) {
            this.dropTargetAdapter = this.createDropTargetListener();
        }
        this.update(editor);
    }

    private void update(VEXEditor vexEditor) {
        TreeViewer treeViewer;
        DropTarget dropTarget;
        StyledText styledText = vexEditor.getTextWidget();
        if (styledText != null && (dropTarget = (DropTarget)styledText.getData("DropTarget")) != null) {
            dropTarget.removeDropListener(this.dropTargetAdapter);
        }
        vexEditor.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StyledText styledText = (StyledText)e.widget;
                DropTarget dropTarget = (DropTarget)styledText.getData("DropTarget");
                if (dropTarget != null) {
                    dropTarget.removeDropListener(XWTEditor.this.dropTargetAdapter);
                }
            }
        });
        dropTarget = (DropTarget)styledText.getData("DropTarget");
        if (dropTarget == null) {
            dropTarget = new DropTarget((Control)styledText, 3);
            dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        }
        dropTarget.addDropListener(this.dropTargetAdapter);
        DragSource dragSource = (DragSource)styledText.getData("DragSource");
        if (dragSource == null) {
            dragSource = new DragSource((Control)styledText, 3);
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            dragSource.setTransfer(types);
        }
        dragSource.addDragListener(this.dragSourceAdapter);
        final PackageExplorerPart part = PackageExplorerPart.getFromActivePerspective();
        if (part != null && (dragSource = (DragSource)(treeViewer = part.getTreeViewer()).getControl().getData("DragSource")) != null) {
            dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

                public void dragStart(DragSourceEvent event) {
                    part.setLinkingEnabled(false);
                }
            });
        }
    }

    private IProgressMonitor getProgressMonitor() {
        ProgressManager progresManager = (ProgressManager)this.getSite().getWorkbenchWindow().getWorkbench().getProgressService();
        IProgressMonitor monitor = progresManager.getDefaultMonitor();
        return monitor;
    }

    private XWTDropTargetListener createDropTargetListener() {
        XWTDropTargetListener dropTargetListener = new XWTDropTargetListener(){

            public void drop(DropTargetEvent event) {
                super.drop(event);
                IFile file = (IFile)XWTEditor.this.getTextEditor().getEditorInput().getAdapter(IFile.class);
                VEXFileFormator formator = new VEXFileFormator();
                IDocument document = XWTEditor.this.getTextEditor().getTextViewer().getDocument();
                try {
                    formator.format(document, file.getContentDescription().getContentType().getId());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                PackageExplorerPart part = PackageExplorerPart.getFromActivePerspective();
                if (part != null) {
                    part.setLinkingEnabled(true);
                }
            }
        };
        dropTargetListener.addDnDAdapter(new PaletteDnDAdapter(this));
        dropTargetListener.addDnDAdapter(new UserDefinedDnDAdapter(this));
        dropTargetListener.addDnDAdapter(new ImageDnDAdapter(this));
        return dropTargetListener;
    }

    public void setFocus() {
        super.setFocus();
        this.refreshXWTView(super.getTextEditor().getTextViewer().getDocument().get());
    }
}

