/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.examples.CreateRemotelyPage;
import org.eclipse.core.resources.semantic.examples.HandlerUtilities;
import org.eclipse.core.resources.semantic.examples.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class HandleCreateRemotely
extends HandlerUtilities {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISemanticFolder sFolder = (ISemanticFolder)this.getSelectedObject(event, ISemanticFolder.class, true);
        if (sFolder == null) {
            this.showPopup(Messages.HandleAddFromRemote_Error_XGRP, Messages.HandleAddFromRemote_NotSemantic_XMSG);
            return null;
        }
        new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)new MyWizard(sFolder)).open();
        return null;
    }

    private final class MyWizard
    extends Wizard {
        final ISemanticFolder parentFolder;

        MyWizard(ISemanticFolder folder) {
            this.parentFolder = folder;
            this.setWindowTitle(Messages.HandleCreateRemotely_CreateRemotely_XGRP);
            this.addPage((IWizardPage)new CreateRemotelyPage(this.parentFolder));
        }

        public boolean performFinish() {
            final CreateRemotelyPage page = (CreateRemotelyPage)this.getPage(CreateRemotelyPage.PAGENAME);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    IWorkspaceRunnable inner = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor actMonitor) throws CoreException {
                            if (page.isFolderMode()) {
                                (this).MyWizard.this.parentFolder.createResourceRemotely(page.getChildName(), null, 0, actMonitor);
                            } else {
                                byte[] contents;
                                try {
                                    contents = page.getContent().getBytes("UTF-8");
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    contents = new byte[]{};
                                }
                                (this).MyWizard.this.parentFolder.createFileRemotely(page.getChildName(), (InputStream)new ByteArrayInputStream(contents), null, 0, actMonitor);
                            }
                        }
                    };
                    try {
                        ResourcesPlugin.getWorkspace().run(inner, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                HandleCreateRemotely.this.submit(Display.getCurrent().getActiveShell(), runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                page.setErrorMessage(e.getCause().getMessage());
                return false;
            }
            return true;
        }
    }
}

