/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.utils;

import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.HashSet;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.e4.xwt.ui.utils.ClassLoaderHelper;
import org.eclipse.e4.xwt.ui.utils.LoadingContext;
import org.eclipse.jdt.core.IJavaProject;

public class ProjectContext
extends LoadingContext {
    protected static WeakHashMap<String, ProjectContext> contexts = new WeakHashMap();
    protected static IResourceChangeListener changeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (!contexts.isEmpty() && delta != null) {
                this.processDelta(delta);
            }
        }

        protected void processDelta(IResourceDelta delta) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                ProjectContext projectContext;
                IResourceDelta resourceDelta = iResourceDeltaArray[n2];
                IProject project = resourceDelta.getResource().getProject();
                if (project != null && project.exists() && (projectContext = contexts.get(name = project.getName())) != null) {
                    projectContext.processDelta(delta);
                } else {
                    this.processDelta(resourceDelta);
                }
                ++n2;
            }
        }
    };
    protected IJavaProject javaProject;
    protected HashSet<String> classes = new HashSet();

    private ProjectContext(IJavaProject javaProject) {
        this.javaProject = javaProject;
        this.resetLoader();
    }

    protected void resetLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.setClassLoader(new RuntimeLoader(classLoader));
        this.firePropertyChangeListener(new PropertyChangeEvent((Object)this, "ClassLoader", null, this.getClassLoader()));
    }

    protected boolean processDelta(IResourceDelta delta) {
        IResourceDelta[] resourceDeltas;
        IResourceDelta[] iResourceDeltaArray = resourceDeltas = delta.getAffectedChildren();
        int n = resourceDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta resourceDelta = iResourceDeltaArray[n2];
            switch (resourceDelta.getKind()) {
                case 4: 
                case 4096: 
                case 8192: {
                    IPath path = resourceDelta.getProjectRelativePath();
                    if (path.isEmpty() || !"class".equals(path.getFileExtension())) break;
                    this.resetLoader();
                    return true;
                }
            }
            IResourceDelta[] iResourceDeltaArray2 = resourceDelta.getAffectedChildren();
            int n3 = iResourceDeltaArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IResourceDelta childDelta = iResourceDeltaArray2[n4];
                IPath path = childDelta.getProjectRelativePath();
                if (!path.isEmpty() && "class".equals(path.getFileExtension())) {
                    this.resetLoader();
                    return true;
                }
                if (this.processDelta(childDelta)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static ProjectContext getContext(IJavaProject javaProject) {
        String elementName = javaProject.getElementName();
        ProjectContext context = contexts.get(elementName);
        if (context == null) {
            context = new ProjectContext(javaProject);
            contexts.put(elementName, context);
        }
        return context;
    }

    public static void start() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(changeListener);
    }

    public static void stop() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(changeListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RuntimeLoader
    extends ClassLoader {
        public RuntimeLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> type = null;
            try {
                type = super.findClass(name);
            }
            catch (ClassNotFoundException e) {
                if (type == null) {
                    type = this.redefined(name);
                }
                if (type == null) {
                    throw e;
                }
                ProjectContext.this.classes.add(name);
            }
            return type;
        }

        public Class<?> redefined(String name) {
            try {
                byte[] content = ClassLoaderHelper.getClassContent(ProjectContext.this.javaProject, name);
                if (content != null) {
                    return this.defineClass(name, content, 0, content.length);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected URL findResource(String name) {
            URL url = super.findResource(name);
            if (url == null) {
                url = ClassLoaderHelper.getResourceAsURL(ProjectContext.this.javaProject, name);
            }
            return url;
        }
    }
}

