/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.dataproviders;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.e4.xwt.IDataProvider;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.core.IBinding;
import org.eclipse.e4.xwt.databinding.JFaceXWTDataBinding;
import org.eclipse.e4.xwt.dataproviders.AbstractDataProvider;
import org.eclipse.e4.xwt.dataproviders.IObjectDataProvider;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDataProvider
extends AbstractDataProvider
implements IObjectDataProvider {
    static IDataProvider.DataModelService dataModelService = new IDataProvider.DataModelService(){

        public Object toModelType(Object object) {
            return JFaceXWTDataBinding.toType(object);
        }

        public Object loadModelType(String className) {
            return XWT.getLoadingContext().loadClass(className);
        }

        public Object toModelPropertyType(Object type, String propertyName) {
            IMetaclass metaclass = XWT.getMetaclass(type);
            IProperty property = metaclass.findProperty(propertyName);
            if (property == null) {
                throw new XWTException(" Property \"" + propertyName + "\" is not found in the class " + metaclass.getType().getName());
            }
            return property.getType();
        }
    };
    private Object objectInstance;
    private Class<?> objectType;
    private String methodName;
    private List<Object> methodParameters;

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public List<Object> getMethodParameters() {
        return this.methodParameters;
    }

    @Override
    public Object getObjectInstance() {
        if (this.objectInstance == null && this.objectType != null) {
            try {
                this.objectInstance = this.objectType.newInstance();
            }
            catch (Exception e) {
                throw new XWTException(e);
            }
        }
        return this.objectInstance;
    }

    @Override
    public Class<?> getObjectType() {
        if (this.objectType == null && this.objectInstance != null) {
            this.objectType = this.objectInstance.getClass();
        }
        return this.objectType;
    }

    @Override
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public void setMethodParameters(List<Object> parameters) {
        this.methodParameters = parameters;
    }

    @Override
    public void setObjectInstance(Object objectImstance) {
        this.objectInstance = objectImstance;
    }

    @Override
    public void setObjectType(Class<?> objectType) {
        this.objectType = objectType;
    }

    protected Object getTarget() {
        Object target = this.getObjectInstance();
        if (target == null) {
            return null;
        }
        Class<?> targetType = this.getObjectType();
        Method method = null;
        if (this.methodName != null) {
            ArrayList paras = new ArrayList();
            if (this.methodParameters != null) {
                for (Object p : this.methodParameters) {
                    paras.add(p.getClass());
                }
            }
            try {
                if (paras.isEmpty()) {
                    method = targetType.getDeclaredMethod(this.methodName, new Class[0]);
                    return method.invoke(target, new Object[0]);
                }
                method = targetType.getDeclaredMethod(this.methodName, paras.toArray(new Class[paras.size()]));
                return method.invoke(target, this.methodParameters.toArray(new Object[this.methodParameters.size()]));
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return target;
    }

    @Override
    public Object getData(String path) {
        if (path == null) {
            return this.getTarget();
        }
        return this.getData(this.getTarget(), path);
    }

    @Override
    public Object getData(Object object, String path) {
        if (object instanceof IObservableValue) {
            object = ((IObservableValue)object).getValue();
        }
        if (path == null || path.trim().length() == 0 || path.equals(".")) {
            return JFaceXWTDataBinding.getValue(object, null);
        }
        int index = path.indexOf(".");
        while (index != -1 && object != null) {
            object = JFaceXWTDataBinding.getValue(object, path.substring(0, index));
            path = path.substring(index + 1);
            index = path.indexOf(".");
        }
        return JFaceXWTDataBinding.getValue(object, path);
    }

    @Override
    public void setData(Object object, String path, Object value) {
        if (object instanceof IObservableValue) {
            object = ((IObservableValue)object).getValue();
        }
        int index = path.indexOf(".");
        while (index != -1 && object != null) {
            object = JFaceXWTDataBinding.getValue(object, path.substring(0, index));
            path = path.substring(index + 1);
            index = path.indexOf(".");
        }
        JFaceXWTDataBinding.setValue(object, path, value);
    }

    @Override
    public void setData(String path, Object value) {
        this.setData(this.getTarget(), path, value);
    }

    @Override
    public Class<?> getDataType(String path) {
        Object target = this.getTarget();
        if (target == null) {
            return null;
        }
        Class<?> type = JFaceXWTDataBinding.toType(target);
        if (path == null) {
            return type;
        }
        return JFaceXWTDataBinding.getValueType(type, path);
    }

    @Override
    public boolean isPropertyReadOnly(String path) {
        Object target = this.getTarget();
        if (target == null || path == null) {
            return true;
        }
        if (target instanceof IBinding) {
            target = ((IBinding)target).getValue(null);
        }
        Class<?> type = JFaceXWTDataBinding.toType(target);
        int index = path.indexOf(".");
        while (index != -1 && target != null) {
            type = JFaceXWTDataBinding.getValueType(type, path.substring(0, index));
            path = path.substring(index + 1);
            index = path.indexOf(".");
        }
        return JFaceXWTDataBinding.isPropertyReadOnly(type, path);
    }

    @Override
    protected IObservableValue observeValue(Object bean, String propertyName) {
        if (JFaceXWTDataBinding.isBeanSupport(bean)) {
            return BeansObservables.observeValue((Realm)XWT.getRealm(), (Object)bean, (String)propertyName);
        }
        return PojoObservables.observeValue((Realm)XWT.getRealm(), (Object)bean, (String)propertyName);
    }

    @Override
    protected IObservableList observeList(Object bean, String propertyName) {
        if (JFaceXWTDataBinding.isBeanSupport(bean)) {
            return BeansObservables.observeList((Realm)XWT.getRealm(), (Object)bean, (String)propertyName);
        }
        return PojoObservables.observeList((Realm)XWT.getRealm(), (Object)bean, (String)propertyName);
    }

    @Override
    protected IObservableSet observeSet(Object bean, String propertyName) {
        if (JFaceXWTDataBinding.isBeanSupport(bean)) {
            return BeansObservables.observeSet((Realm)XWT.getRealm(), (Object)bean, (String)propertyName);
        }
        return PojoObservables.observeSet((Realm)XWT.getRealm(), (Object)bean, (String)propertyName);
    }

    @Override
    protected IObservableList observeDetailList(IObservableValue bean, Object elementType, String propertyName, Object propertyType) {
        if (JFaceXWTDataBinding.isBeanSupport(bean)) {
            return BeansObservables.observeDetailList((IObservableValue)bean, (String)propertyName, (Class)((Class)propertyType));
        }
        return PojoObservables.observeDetailList((IObservableValue)bean, (String)propertyName, (Class)((Class)propertyType));
    }

    @Override
    protected IObservableSet observeDetailSet(IObservableValue bean, Object elementType, String propertyName, Object propertyType) {
        if (JFaceXWTDataBinding.isBeanSupport(bean)) {
            return BeansObservables.observeDetailSet((IObservableValue)bean, (String)propertyName, (Class)((Class)propertyType));
        }
        return PojoObservables.observeDetailSet((IObservableValue)bean, (String)propertyName, (Class)((Class)propertyType));
    }

    @Override
    protected IObservableValue observeDetailValue(IObservableValue master, Object elementType, String propertyName, Object propertyType) {
        Class beanClass = (Class)elementType;
        if (beanClass == null && master.getValueType() instanceof Class) {
            beanClass = (Class)master.getValueType();
        }
        if (JFaceXWTDataBinding.isBeanSupport(beanClass)) {
            return BeanProperties.value((Class)beanClass, (String)propertyName, (Class)((Class)propertyType)).observeDetail(master);
        }
        return PojoProperties.value((Class)beanClass, (String)propertyName, (Class)((Class)propertyType)).observeDetail(master);
    }

    @Override
    public IValueProperty createValueProperty(Object type, String propertyName) {
        if (JFaceXWTDataBinding.isBeanSupport(type)) {
            return BeanProperties.value(JFaceXWTDataBinding.toType(type), (String)propertyName);
        }
        return PojoProperties.value(JFaceXWTDataBinding.toType(type), (String)propertyName);
    }

    @Override
    public IDataProvider.DataModelService getModelService() {
        return dataModelService;
    }
}

