/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.platform.discovery.core.api.IContributedAction;
import org.eclipse.platform.discovery.core.internal.IDiscoveryView;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.IMasterDiscoveryView;
import org.eclipse.platform.discovery.ui.api.IViewUiContext;
import org.eclipse.platform.discovery.ui.api.impl.ILabeledSelection;
import org.eclipse.platform.discovery.ui.internal.view.ICustomizableView;
import org.eclipse.platform.discovery.ui.internal.view.impl.SearchConsoleSelectionProvider;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractDiscoveryView<O, C>
extends ViewPart
implements IDiscoveryView<O, C>,
ICustomizableView,
ITabbedPropertySheetPageContributor,
IMasterDiscoveryView {
    private static final String TABBED_PROPERTY_CONTRIBUTOR_ID = "org.eclipse.platform.discovery.ui.view.tabbedprop.searchconsole";
    private final Set<IContributedAction> viewActions = new HashSet<IContributedAction>();
    private final Set<IGenericViewCustomization> viewCustomizations = new HashSet<IGenericViewCustomization>();
    protected FormToolkit formToolkit = new FormToolkit(PlatformUI.getWorkbench().getDisplay());
    private final ISelectionProvider viewSelectionProvider = this.consoleViewSelectionProvider();
    private IViewUiContext uiContext;
    private IDiscoveryEnvironment environment;

    public String getContributorId() {
        return TABBED_PROPERTY_CONTRIBUTOR_ID;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    public void createPartControl(Composite parent) {
        this.getSite().setSelectionProvider(this.viewSelectionProvider);
    }

    protected ISelectionProvider consoleViewSelectionProvider() {
        return new SearchConsoleSelectionProvider(new SearchConsoleSelectionProvider.IViewCustomizationsObtainer(){

            @Override
            public Set<IGenericViewCustomization> viewCustomizations() {
                return AbstractDiscoveryView.this.viewCustomizations();
            }
        });
    }

    @Override
    public void registerAction(IContributedAction action) {
        this.viewActions.add(action);
    }

    public Set<IContributedAction> viewActions() {
        return this.viewActions;
    }

    public Set<IGenericViewCustomization> viewCustomizations() {
        return this.viewCustomizations;
    }

    @Override
    public void registerViewCustomization(IGenericViewCustomization customization) {
        this.viewCustomizations.add(customization);
    }

    public void initializationCompleted() {
        this.getProgressMonitor().done();
    }

    protected Color getGradientStart() {
        return this.formToolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START");
    }

    protected Color getGradientEnd() {
        return this.formToolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END");
    }

    public void setResultSelection(ILabeledSelection sel) {
        this.viewSelectionProvider.setSelection((ISelection)sel);
    }

    public void dispose() {
        super.dispose();
        this.formToolkit.dispose();
    }

    @Override
    public void setUiContext(IViewUiContext uiContext) {
        this.uiContext = uiContext;
    }

    protected IViewUiContext uiContext() {
        return this.uiContext;
    }

    public void setEnvironment(IDiscoveryEnvironment env) {
        this.environment = env;
    }

    @Override
    public IDiscoveryEnvironment getEnvironment() {
        return this.environment;
    }
}

