/*
 * Decompiled with CFR 0.152.
 */
package test.swt;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.pushingpixels.trident.Timeline;

public class ButtonFgLoop {
    private static Timeline createTimeline(Button button) {
        Timeline timeline = new Timeline(button);
        timeline.setDuration(1500L);
        timeline.addPropertyToInterpolate("foreground", button.getForeground(), Display.getDefault().getSystemColor(3));
        return timeline;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setSize(300, 200);
        GridLayout layout = new GridLayout();
        shell.setLayout((Layout)layout);
        Button buttonWithCancel = new Button((Composite)shell, 16);
        GridData gridData = new GridData(2, 2, true, false);
        buttonWithCancel.setLayoutData((Object)gridData);
        buttonWithCancel.setText("sample w/cancel");
        final Timeline timelineWithCancel = ButtonFgLoop.createTimeline(buttonWithCancel);
        buttonWithCancel.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                timelineWithCancel.playLoop(Timeline.RepeatBehavior.REVERSE);
            }

            public void mouseExit(MouseEvent e) {
                timelineWithCancel.cancelAtCycleBreak();
            }
        });
        Button buttonWithRevert = new Button((Composite)shell, 16);
        GridData gridDataRevert = new GridData(2, 2, true, false);
        buttonWithRevert.setLayoutData((Object)gridDataRevert);
        buttonWithRevert.setText("sample w/cancel");
        final Timeline timelineWithRevert = ButtonFgLoop.createTimeline(buttonWithRevert);
        buttonWithRevert.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                timelineWithRevert.playLoop(Timeline.RepeatBehavior.REVERSE);
            }

            public void mouseExit(MouseEvent e) {
                timelineWithRevert.playReverse();
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

