/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.deeplink.internal;

import java.util.Collection;
import java.util.Properties;

public class DeepLinkProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    static final int DEFAULT_BASE_PORT_NUMBER = 9000;
    private static final String BASE_PORT_NUMBER_KEY = "base.port.number";
    private static final String INSTALLATION_PREFIX = "instance.";
    private static final String INSTALLATION_PORT_SUFFIX = ".port";
    private static final String INSTALLATION_COMMAND_SUFFIX = ".command";
    private int nextPortNumber = this.getBasePortNumber();

    public DeepLinkProperties() {
    }

    public DeepLinkProperties(Properties defaults) {
        super(defaults);
    }

    private String installationPortKey(String myInstallation) {
        return INSTALLATION_PREFIX + myInstallation + INSTALLATION_PORT_SUFFIX;
    }

    public int getBasePortNumber() {
        String basePortString = this.getProperty(BASE_PORT_NUMBER_KEY);
        int basePortNumber = basePortString == null ? 9000 : Integer.parseInt(basePortString);
        return basePortNumber;
    }

    public String getInstallationPort(String myInstallation) {
        return this.getProperty(this.installationPortKey(myInstallation));
    }

    public void setInstallationPort(String myInstallation, int port) {
        this.setProperty(this.installationPortKey(myInstallation), Integer.toString(port));
    }

    public void removeInstallationPort(String myInstallation) {
        this.remove(this.installationPortKey(myInstallation));
    }

    public boolean isPortNumberUnique(String myInstallation, String portNumber) {
        Properties tempProperties = (Properties)this.clone();
        tempProperties.remove(BASE_PORT_NUMBER_KEY);
        tempProperties.remove(this.installationPortKey(myInstallation));
        return !tempProperties.values().contains(portNumber);
    }

    public int calculateNextPortNumber() {
        Properties tempProperties = (Properties)this.clone();
        tempProperties.remove(BASE_PORT_NUMBER_KEY);
        Collection<Object> values = tempProperties.values();
        while (values.contains(Integer.toString(this.nextPortNumber))) {
            ++this.nextPortNumber;
        }
        return this.nextPortNumber;
    }

    public String getInstallationCommand(String installation) {
        String key = INSTALLATION_PREFIX + installation + INSTALLATION_COMMAND_SUFFIX;
        return this.getProperty(key);
    }
}

