/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.ecore.javascript;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.e4.emf.ecore.javascript.ScriptClassLoader;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

class Script {
    private static final Logger log = Logger.getLogger(Script.class.getName());
    Scriptable scope;
    URI uri;
    File file;
    long loadTimestamp;
    private static Map<URI, org.mozilla.javascript.Script> compiledScripts = new HashMap<URI, org.mozilla.javascript.Script>();
    private static Class<?>[] constructorParameterTypes = new Class[]{Scriptable.class, Context.class, Integer.TYPE};

    Script(URI uri, Scriptable scope) {
        this.uri = uri;
        this.scope = scope;
    }

    boolean shouldLoadScript() {
        long lastModified;
        if (this.scope == null) {
            return true;
        }
        if (this.file == null && this.loadTimestamp > 0L) {
            return false;
        }
        return this.file != null && this.file.exists() && this.loadTimestamp > 0L && (lastModified = this.file.lastModified()) > this.loadTimestamp;
    }

    void loadScript(URIConverter uriConverter, ScriptClassLoader scriptClassLoader) {
        URI physicalUri;
        Exception scriptException;
        block13: {
            scriptException = null;
            if (!uriConverter.exists(this.uri, null)) {
                return;
            }
            physicalUri = uriConverter.normalize(this.uri);
            org.mozilla.javascript.Script compiled = compiledScripts.get(physicalUri);
            if (compiled == null && scriptClassLoader != null) {
                URI classUri = physicalUri.trimFileExtension().appendFileExtension("class");
                compiled = this.getCompiledScript(classUri, uriConverter, scriptClassLoader);
            }
            if (compiled == null) {
                try {
                    compiled = this.compileScript(this.getScriptInputStream(physicalUri, uriConverter), physicalUri);
                }
                catch (Exception e) {
                    scriptException = e;
                }
            } else {
                log.info("Reusing compiled script for " + this.uri);
            }
            if (compiled != null) {
                Context context = Context.enter();
                try {
                    try {
                        compiled.exec(context, this.scope);
                        log.info("Executed script for " + this.uri + " from " + (this.file != null ? this.file : physicalUri) + " @ " + this.loadTimestamp);
                    }
                    catch (Exception e) {
                        scriptException = e;
                        Context.exit();
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    Context.exit();
                    throw throwable;
                }
                Context.exit();
            }
        }
        if (scriptException != null) {
            log.log(Level.WARNING, "Could not load script from " + physicalUri + ": " + scriptException);
        }
    }

    private org.mozilla.javascript.Script getCompiledScript(URI uri, URIConverter uriConverter, ScriptClassLoader scriptClassLoader) {
        scriptClassLoader.setUri(uri, uriConverter);
        String className = ScriptClassLoader.getUriClassName(uri);
        ScriptClassLoader classLoader = scriptClassLoader;
        Class<?> jsClass = null;
        try {
            jsClass = ((ClassLoader)classLoader).loadClass(className);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        Context context = Context.enter();
        try {
            org.mozilla.javascript.Script script = (org.mozilla.javascript.Script)jsClass.getConstructor(constructorParameterTypes).newInstance(this.scope, context, 0);
            return script;
        }
        catch (Exception exception) {
            return null;
        }
        finally {
            Context.exit();
        }
    }

    private InputStream getScriptInputStream(URI physicalUri, URIConverter uriConverter) throws Exception {
        InputStream is = null;
        IOException scriptException = null;
        if (physicalUri.isFile()) {
            String fileName = physicalUri.toFileString();
            try {
                is = new FileInputStream(fileName);
                this.file = new File(fileName);
            }
            catch (FileNotFoundException e) {
                scriptException = e;
            }
        }
        if (is == null) {
            try {
                is = uriConverter.createInputStream(physicalUri);
            }
            catch (IOException e) {
                scriptException = e;
            }
        }
        if (is == null) {
            throw scriptException;
        }
        return is;
    }

    private org.mozilla.javascript.Script compileScript(InputStream is, URI physicalUri) throws Exception {
        Exception scriptException;
        org.mozilla.javascript.Script compiled;
        block13: {
            InputStreamReader reader = new InputStreamReader(is);
            Context context = Context.enter();
            compiled = null;
            scriptException = null;
            try {
                try {
                    compiled = context.compileReader((Reader)reader, physicalUri.toFileString(), -1, null);
                    log.info("Compiled script for " + this.uri + " from " + (this.file != null ? this.file : physicalUri) + " @ " + this.loadTimestamp);
                    compiledScripts.put(this.uri, compiled);
                    compiledScripts.put(physicalUri, compiled);
                    if (this.file != null && this.file.exists()) {
                        this.loadTimestamp = this.file.lastModified();
                    }
                }
                catch (Exception e) {
                    scriptException = e;
                    Context.exit();
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException iOException) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                Context.exit();
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            Context.exit();
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
        if (compiled == null) {
            throw scriptException;
        }
        return compiled;
    }
}

