/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.result.impl;

import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.platform.discovery.core.api.IContributedAction;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.ui.api.IResultsViewAccessor;
import org.eclipse.platform.discovery.ui.api.ISearchConsoleCustomization;
import org.eclipse.platform.discovery.ui.api.impl.LabeledSelection;
import org.eclipse.platform.discovery.ui.api.impl.SearchResultCustomUiCreator;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.ui.internal.view.dnd.impl.DragSrcInteractionListener;
import org.eclipse.platform.discovery.ui.internal.view.dnd.impl.LocalContextSelectionTransferSetter;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.DiscoveryTreeViewerFactory;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GenericResultUiCreator
extends SearchResultCustomUiCreator {
    private IDiscoveryEnvironment env;
    private IResultsViewAccessor va;

    @Override
    public void restore(Object data) {
        if (!this.va.getTreeViewer().getTree().isDisposed()) {
            this.va.getTreeViewer().setExpandedTreePaths((TreePath[])data);
        }
    }

    @Override
    public Object restoreData() {
        if (this.va.getTreeViewer().getTree().isDisposed()) {
            return null;
        }
        return this.va.getTreeViewer().getExpandedTreePaths();
    }

    public GenericResultUiCreator(String searchProviderId, IDiscoveryEnvironment env) {
        this.env = env;
    }

    @Override
    public Composite createSearchUi(Composite parent, ISearchContext searchContext, FormToolkit formToolkit, Set<IContributedAction> actions, Set<ISearchConsoleCustomization> viewCustomizations) {
        DiscoveryTreeViewerFactory f = this.newDiscoveryTreeViewerFactory();
        parent.setLayout((Layout)new GridLayout(1, true));
        if (searchContext.description() != null) {
            Label l = formToolkit.createLabel(parent, searchContext.description());
            l.setLayoutData((Object)new GridData(1, 1, false, false));
        }
        this.va = f.createTreeViewer(parent, viewCustomizations, actions, this.env);
        this.va.getTreeViewer().getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.va.getTreeViewer().setInput((Object)searchContext);
        this.va.getTreeViewer().refresh();
        if (this.va.getTreeViewer().getTree().getItems().length == 0) {
            this.va.getTreeViewer().getTree().dispose();
            formToolkit.createLabel(parent, DiscoveryUIMessages.NoResultsUiCreator_NO_RESULTS_FOUND);
            parent.layout();
        }
        for (ISearchConsoleCustomization viewCustomization : viewCustomizations) {
            viewCustomization.postResultDisplayed(this.va);
        }
        return parent;
    }

    private DiscoveryTreeViewerFactory newDiscoveryTreeViewerFactory() {
        return new DiscoveryTreeViewerFactory(){

            @Override
            protected DragSrcInteractionListener.ITransferDataSetter<? extends Transfer>[] supportedTransferDataSetters(IDiscoveryEnvironment env) {
                DragSrcInteractionListener.ITransferDataSetter<? extends Transfer>[] superTypes = super.supportedTransferDataSetters(env);
                DragSrcInteractionListener.ITransferDataSetter[] supportedTypes = new DragSrcInteractionListener.ITransferDataSetter[superTypes.length + 1];
                System.arraycopy(superTypes, 0, supportedTypes, 0, superTypes.length);
                supportedTypes[supportedTypes.length - 1] = new LocalContextSelectionTransferSetter();
                return supportedTypes;
            }
        };
    }

    @Override
    public void registerResultSelectionChangedListener(ISelectionChangedListener selChangedListener) {
        new LabeledSelectionChangedEventAdapter((StructuredViewer)this.va.getTreeViewer(), selChangedListener).registerForSelectionEvent();
    }

    private static class LabeledSelectionChangedEventAdapter
    implements ISelectionChangedListener {
        private final ISelectionChangedListener toAdapt;
        private final StructuredViewer v;

        public LabeledSelectionChangedEventAdapter(StructuredViewer v, ISelectionChangedListener toAdapt) {
            this.v = v;
            this.toAdapt = toAdapt;
        }

        public void registerForSelectionEvent() {
            this.v.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionChangedEvent delegatedEvent = new SelectionChangedEvent(event.getSelectionProvider(), (ISelection)new LabeledSelection((ILabelProvider)this.v.getLabelProvider(), (IStructuredSelection)event.getSelection()));
            this.toAdapt.selectionChanged(delegatedEvent);
        }
    }
}

