/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerWindowTest
extends ModelReconcilerTest {
    public void testWindow_X() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setX(100);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setX(200);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)100, (int)window.getX());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)200, (int)window.getX());
    }

    public void testWindow_Y() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setY(100);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setY(200);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)100, (int)window.getY());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)200, (int)window.getY());
    }

    public void testWindow_Width() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setWidth(100);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setWidth(200);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)100, (int)window.getWidth());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)200, (int)window.getWidth());
    }

    public void testWindow_Height() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setHeight(100);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setHeight(200);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)100, (int)window.getHeight());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)200, (int)window.getHeight());
    }

    public void testWindow_Menu_Set() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertNull((Object)window.getMainMenu());
        this.applyAll(deltas);
        menu = window.getMainMenu();
        ModelReconcilerWindowTest.assertNotNull((Object)menu);
    }

    public void testWindow_Menu_Unset() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setMainMenu(null);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertNull((Object)window.getMainMenu());
    }

    private void testWindow_Menu_Visible(boolean before, boolean after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        menu.setToBeRendered(before);
        window.setMainMenu(menu);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        menu.setToBeRendered(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((boolean)before, (boolean)menu.isToBeRendered());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((boolean)after, (boolean)menu.isToBeRendered());
    }

    public void testWindow_Menu_Children_Add() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MDirectMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        menuItem.setLabel("File");
        menu.getChildren().add(menuItem);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerWindowTest.assertEquals((int)0, (int)menu.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerWindowTest.assertEquals((int)1, (int)menu.getChildren().size());
        ModelReconcilerWindowTest.assertNotNull(menu.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((String)"File", (String)((MMenuElement)menu.getChildren().get(0)).getLabel());
    }

    public void testWindow_Menu_Children_Remove() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        MDirectMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        menuItem.setLabel("File");
        menu.getChildren().add(menuItem);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        menu.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerWindowTest.assertEquals((int)1, (int)menu.getChildren().size());
        ModelReconcilerWindowTest.assertNotNull(menu.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((String)"File", (String)((MMenuElement)menu.getChildren().get(0)).getLabel());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerWindowTest.assertEquals((int)0, (int)menu.getChildren().size());
    }

    public void testWindow_Menu_Visible_TrueTrue() {
        this.testWindow_Menu_Visible(true, true);
    }

    public void testWindow_Menu_Visible_TrueFalse() {
        this.testWindow_Menu_Visible(true, false);
    }

    public void testWindow_Menu_Visible_FalseTrue() {
        this.testWindow_Menu_Visible(false, true);
    }

    public void testWindow_Menu_Visible_FalseFalse() {
        this.testWindow_Menu_Visible(false, false);
    }

    public void testWindow_NestedMenu() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        menu.setLabel("menuLabel");
        MMenu item = MenuFactoryImpl.eINSTANCE.createMenu();
        item.setLabel("itemLabel");
        menu.getChildren().add(item);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerWindowTest.assertNull((Object)menu.getLabel());
        ModelReconcilerWindowTest.assertEquals((int)0, (int)menu.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerWindowTest.assertEquals((String)"menuLabel", (String)menu.getLabel());
        ModelReconcilerWindowTest.assertEquals((int)1, (int)menu.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((String)"itemLabel", (String)((MMenuElement)menu.getChildren().get(0)).getLabel());
    }

    public void testWindow_SharedElements_Add() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getSharedElements().add(part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((int)0, (int)window.getSharedElements().size());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((int)1, (int)window.getSharedElements().size());
        ModelReconcilerWindowTest.assertTrue((boolean)(window.getSharedElements().get(0) instanceof MPart));
    }

    public void testWindow_SharedElements_Remove() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getSharedElements().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.getSharedElements().remove(part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getSharedElements().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((int)1, (int)window.getSharedElements().size());
        ModelReconcilerWindowTest.assertEquals((Object)part, window.getSharedElements().get(0));
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((int)0, (int)window.getSharedElements().size());
    }
}

